"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    ml_model_id: str,
    ml_model_type: str,
    training_data_source_id: str,
    ml_model_name: str = None,
    parameters: Dict = None,
    recipe: str = None,
    recipe_uri: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new MLModel using the DataSource and the recipe as information sources.  An MLModel is nearly immutable. Users can update only the MLModelName and the ScoreThreshold in an MLModel without creating a new MLModel.   CreateMLModel is an asynchronous operation. In response to CreateMLModel, Amazon Machine Learning (Amazon ML) immediately returns and sets the MLModel status to PENDING. After the MLModel has been created and ready is for use, Amazon ML sets the status to COMPLETED.  You can use the GetMLModel operation to check the progress of the MLModel during the creation operation.  CreateMLModel requires a DataSource with computed statistics, which can be created by setting ComputeStatistics to true in CreateDataSourceFromRDS, CreateDataSourceFromS3, or CreateDataSourceFromRedshift operations.

    Args:
        ml_model_id(str): A user-supplied ID that uniquely identifies the MLModel.
        ml_model_name(str, optional): A user-supplied name or description of the MLModel. Defaults to None.
        ml_model_type(str): The category of supervised learning that this MLModel will address. Choose from the following types:   Choose REGRESSION if the MLModel will be used to predict a numeric value.   Choose BINARY if the MLModel result has two possible values.   Choose MULTICLASS if the MLModel result has a limited number of values.    For more information, see the Amazon Machine Learning Developer Guide.
        parameters(Dict, optional): A list of the training parameters in the MLModel. The list is implemented as a map of key-value pairs. The following is the current set of training parameters:    sgd.maxMLModelSizeInBytes - The maximum allowed size of the model. Depending on the input data, the size of the model might affect its performance.  The value is an integer that ranges from 100000 to 2147483648. The default value is 33554432.    sgd.maxPasses - The number of times that the training process traverses the observations to build the MLModel. The value is an integer that ranges from 1 to 10000. The default value is 10.    sgd.shuffleType - Whether Amazon ML shuffles the training data. Shuffling the data improves a model's ability to find the optimal solution for a variety of data types. The valid values are auto and none. The default value is none. We strongly recommend that you shuffle your data.    sgd.l1RegularizationAmount - The coefficient regularization L1 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse feature set. If you use this parameter, start by specifying a small value, such as 1.0E-08. The value is a double that ranges from 0 to MAX_DOUBLE. The default is to not use L1 normalization. This parameter can't be used when L2 is specified. Use this parameter sparingly.    sgd.l2RegularizationAmount - The coefficient regularization L2 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this parameter, start by specifying a small value, such as 1.0E-08. The value is a double that ranges from 0 to MAX_DOUBLE. The default is to not use L2 normalization. This parameter can't be used when L1 is specified. Use this parameter sparingly.  . Defaults to None.
        training_data_source_id(str): The DataSource that points to the training data.
        recipe(str, optional): The data recipe for creating the MLModel. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default. Defaults to None.
        recipe_uri(str, optional): The Amazon Simple Storage Service (Amazon S3) location and file name that contains the MLModel recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.ml_model.create(
                ctx, ml_model_id=value, ml_model_type=value, training_data_source_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.ml_model.create ml_model_id=value, ml_model_type=value, training_data_source_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="create_ml_model",
        op_kwargs={
            "MLModelId": ml_model_id,
            "MLModelName": ml_model_name,
            "MLModelType": ml_model_type,
            "Parameters": parameters,
            "TrainingDataSourceId": training_data_source_id,
            "Recipe": recipe,
            "RecipeUri": recipe_uri,
        },
    )


async def delete(hub, ctx, ml_model_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Assigns the DELETED status to an MLModel, rendering it unusable. After using the DeleteMLModel operation, you can use the GetMLModel operation to verify that the status of the MLModel changed to DELETED.  Caution: The result of the DeleteMLModel operation is irreversible.

    Args:
        ml_model_id(str): A user-supplied ID that uniquely identifies the MLModel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.ml_model.delete(ctx, ml_model_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.ml_model.delete ml_model_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="delete_ml_model",
        op_kwargs={"MLModelId": ml_model_id},
    )


async def describe_all(
    hub,
    ctx,
    filter_variable: str = None,
    eq: str = None,
    gt: str = None,
    lt: str = None,
    ge: str = None,
    le: str = None,
    ne: str = None,
    prefix: str = None,
    sort_order: str = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of MLModel that match the search criteria in the request.

    Args:
        filter_variable(str, optional): Use one of the following variables to filter a list of MLModel:    CreatedAt - Sets the search criteria to MLModel creation date.    Status - Sets the search criteria to MLModel status.    Name - Sets the search criteria to the contents of MLModel   Name.    IAMUser - Sets the search criteria to the user account that invoked the MLModel creation.    TrainingDataSourceId - Sets the search criteria to the DataSource used to train one or more MLModel.    RealtimeEndpointStatus - Sets the search criteria to the MLModel real-time endpoint status.    MLModelType - Sets the search criteria to MLModel type: binary, regression, or multi-class.    Algorithm - Sets the search criteria to the algorithm that the MLModel uses.    TrainingDataURI - Sets the search criteria to the data file(s) used in training a MLModel. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.  . Defaults to None.
        eq(str, optional): The equal to operator. The MLModel results will have FilterVariable values that exactly match the value specified with EQ. Defaults to None.
        gt(str, optional): The greater than operator. The MLModel results will have FilterVariable values that are greater than the value specified with GT. Defaults to None.
        lt(str, optional): The less than operator. The MLModel results will have FilterVariable values that are less than the value specified with LT. Defaults to None.
        ge(str, optional): The greater than or equal to operator. The MLModel results will have FilterVariable values that are greater than or equal to the value specified with GE. . Defaults to None.
        le(str, optional): The less than or equal to operator. The MLModel results will have FilterVariable values that are less than or equal to the value specified with LE. Defaults to None.
        ne(str, optional): The not equal to operator. The MLModel results will have FilterVariable values not equal to the value specified with NE. Defaults to None.
        prefix(str, optional): A string that is found at the beginning of a variable, such as Name or Id. For example, an MLModel could have the Name 2014-09-09-HolidayGiftMailer. To search for this MLModel, select Name for the FilterVariable and any of the following strings for the Prefix:    2014-09   2014-09-09   2014-09-09-Holiday  . Defaults to None.
        sort_order(str, optional): A two-value parameter that determines the sequence of the resulting list of MLModel.    asc - Arranges the list in ascending order (A-Z, 0-9).    dsc - Arranges the list in descending order (Z-A, 9-0).   Results are sorted by FilterVariable. Defaults to None.
        next_token(str, optional): The ID of the page in the paginated results. Defaults to None.
        limit(int, optional): The number of pages of information to include in the result. The range of acceptable values is 1 through 100. The default value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.ml_model.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.ml_model.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="describe_ml_models",
        op_kwargs={
            "FilterVariable": filter_variable,
            "EQ": eq,
            "GT": gt,
            "LT": lt,
            "GE": ge,
            "LE": le,
            "NE": ne,
            "Prefix": prefix,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def get(hub, ctx, ml_model_id: str, verbose: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns an MLModel that includes detailed metadata, data source information, and the current status of the MLModel.  GetMLModel provides results in normal or verbose format.

    Args:
        ml_model_id(str): The ID assigned to the MLModel at creation.
        verbose(bool, optional): Specifies whether the GetMLModel operation should return Recipe. If true, Recipe is returned. If false, Recipe is not returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.ml_model.get(ctx, ml_model_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.ml_model.get ml_model_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="get_ml_model",
        op_kwargs={"MLModelId": ml_model_id, "Verbose": verbose},
    )


async def update(
    hub, ctx, ml_model_id: str, ml_model_name: str = None, score_threshold: float = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the MLModelName and the ScoreThreshold of an MLModel. You can use the GetMLModel operation to view the contents of the updated data element.

    Args:
        ml_model_id(str): The ID assigned to the MLModel during creation.
        ml_model_name(str, optional): A user-supplied name or description of the MLModel. Defaults to None.
        score_threshold(float, optional): The ScoreThreshold used in binary classification MLModel that marks the boundary between a positive prediction and a negative prediction. Output values greater than or equal to the ScoreThreshold receive a positive result from the MLModel, such as true. Output values less than the ScoreThreshold receive a negative response from the MLModel, such as false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.ml_model.update(ctx, ml_model_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.ml_model.update ml_model_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="update_ml_model",
        op_kwargs={
            "MLModelId": ml_model_id,
            "MLModelName": ml_model_name,
            "ScoreThreshold": score_threshold,
        },
    )
