"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def predict(
    hub, ctx, ml_model_id: str, record: Dict, predict_endpoint: str
) -> Dict:
    r"""
    **Autogenerated function**

    Generates a prediction for the observation using the specified ML Model.  Note: Not all response parameters will be populated. Whether a response parameter is populated depends on the type of model requested.

    Args:
        ml_model_id(str): A unique identifier of the MLModel.
        record(Dict): A map of variable name-value pairs that represent an observation.
        predict_endpoint(str): .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.init.predict(
                ctx, ml_model_id=value, record=value, predict_endpoint=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.init.predict ml_model_id=value, record=value, predict_endpoint=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="predict",
        op_kwargs={
            "MLModelId": ml_model_id,
            "Record": record,
            "PredictEndpoint": predict_endpoint,
        },
    )
