"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    evaluation_id: str,
    ml_model_id: str,
    evaluation_data_source_id: str,
    evaluation_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Evaluation of an MLModel. An MLModel is evaluated on a set of observations associated to a DataSource. Like a DataSource for an MLModel, the DataSource for an Evaluation contains values for the Target Variable. The Evaluation compares the predicted result for each observation to the actual outcome and provides a summary so that you know how effective the MLModel functions on the test data. Evaluation generates a relevant performance metric, such as BinaryAUC, RegressionRMSE or MulticlassAvgFScore based on the corresponding MLModelType: BINARY, REGRESSION or MULTICLASS.   CreateEvaluation is an asynchronous operation. In response to CreateEvaluation, Amazon Machine Learning (Amazon ML) immediately returns and sets the evaluation status to PENDING. After the Evaluation is created and ready for use, Amazon ML sets the status to COMPLETED.  You can use the GetEvaluation operation to check progress of the evaluation during the creation operation.

    Args:
        evaluation_id(str): A user-supplied ID that uniquely identifies the Evaluation.
        evaluation_name(str, optional): A user-supplied name or description of the Evaluation. Defaults to None.
        ml_model_id(str): The ID of the MLModel to evaluate. The schema used in creating the MLModel must match the schema of the DataSource used in the Evaluation.
        evaluation_data_source_id(str): The ID of the DataSource for the evaluation. The schema of the DataSource must match the schema used to create the MLModel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.evaluation.create(
                ctx, evaluation_id=value, ml_model_id=value, evaluation_data_source_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.evaluation.create evaluation_id=value, ml_model_id=value, evaluation_data_source_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="create_evaluation",
        op_kwargs={
            "EvaluationId": evaluation_id,
            "EvaluationName": evaluation_name,
            "MLModelId": ml_model_id,
            "EvaluationDataSourceId": evaluation_data_source_id,
        },
    )


async def delete(hub, ctx, evaluation_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Assigns the DELETED status to an Evaluation, rendering it unusable. After invoking the DeleteEvaluation operation, you can use the GetEvaluation operation to verify that the status of the Evaluation changed to DELETED.  Caution: The results of the DeleteEvaluation operation are irreversible.

    Args:
        evaluation_id(str): A user-supplied ID that uniquely identifies the Evaluation to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.evaluation.delete(ctx, evaluation_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.evaluation.delete evaluation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="delete_evaluation",
        op_kwargs={"EvaluationId": evaluation_id},
    )


async def describe_all(
    hub,
    ctx,
    filter_variable: str = None,
    eq: str = None,
    gt: str = None,
    lt: str = None,
    ge: str = None,
    le: str = None,
    ne: str = None,
    prefix: str = None,
    sort_order: str = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of DescribeEvaluations that match the search criteria in the request.

    Args:
        filter_variable(str, optional): Use one of the following variable to filter a list of Evaluation objects:    CreatedAt - Sets the search criteria to the Evaluation creation date.    Status - Sets the search criteria to the Evaluation status.    Name - Sets the search criteria to the contents of Evaluation   Name.    IAMUser - Sets the search criteria to the user account that invoked an Evaluation.    MLModelId - Sets the search criteria to the MLModel that was evaluated.    DataSourceId - Sets the search criteria to the DataSource used in Evaluation.    DataUri - Sets the search criteria to the data file(s) used in Evaluation. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.  . Defaults to None.
        eq(str, optional): The equal to operator. The Evaluation results will have FilterVariable values that exactly match the value specified with EQ. Defaults to None.
        gt(str, optional): The greater than operator. The Evaluation results will have FilterVariable values that are greater than the value specified with GT. Defaults to None.
        lt(str, optional): The less than operator. The Evaluation results will have FilterVariable values that are less than the value specified with LT. Defaults to None.
        ge(str, optional): The greater than or equal to operator. The Evaluation results will have FilterVariable values that are greater than or equal to the value specified with GE. . Defaults to None.
        le(str, optional): The less than or equal to operator. The Evaluation results will have FilterVariable values that are less than or equal to the value specified with LE. Defaults to None.
        ne(str, optional): The not equal to operator. The Evaluation results will have FilterVariable values not equal to the value specified with NE. Defaults to None.
        prefix(str, optional): A string that is found at the beginning of a variable, such as Name or Id. For example, an Evaluation could have the Name 2014-09-09-HolidayGiftMailer. To search for this Evaluation, select Name for the FilterVariable and any of the following strings for the Prefix:    2014-09   2014-09-09   2014-09-09-Holiday  . Defaults to None.
        sort_order(str, optional): A two-value parameter that determines the sequence of the resulting list of Evaluation.    asc - Arranges the list in ascending order (A-Z, 0-9).    dsc - Arranges the list in descending order (Z-A, 9-0).   Results are sorted by FilterVariable. Defaults to None.
        next_token(str, optional): The ID of the page in the paginated results. Defaults to None.
        limit(int, optional):  The maximum number of Evaluation to include in the result. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.evaluation.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.evaluation.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="describe_evaluations",
        op_kwargs={
            "FilterVariable": filter_variable,
            "EQ": eq,
            "GT": gt,
            "LT": lt,
            "GE": ge,
            "LE": le,
            "NE": ne,
            "Prefix": prefix,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def get(hub, ctx, evaluation_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns an Evaluation that includes metadata as well as the current status of the Evaluation.

    Args:
        evaluation_id(str): The ID of the Evaluation to retrieve. The evaluation of each MLModel is recorded and cataloged. The ID provides the means to access the information. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.evaluation.get(ctx, evaluation_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.evaluation.get evaluation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="get_evaluation",
        op_kwargs={"EvaluationId": evaluation_id},
    )


async def update(hub, ctx, evaluation_id: str, evaluation_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates the EvaluationName of an Evaluation. You can use the GetEvaluation operation to view the contents of the updated data element.

    Args:
        evaluation_id(str): The ID assigned to the Evaluation during creation.
        evaluation_name(str): A new user-supplied name or description of the Evaluation that will replace the current content. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.evaluation.update(
                ctx, evaluation_id=value, evaluation_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.evaluation.update evaluation_id=value, evaluation_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="update_evaluation",
        op_kwargs={"EvaluationId": evaluation_id, "EvaluationName": evaluation_name},
    )
