"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, data_source_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Assigns the DELETED status to a DataSource, rendering it unusable. After using the DeleteDataSource operation, you can use the GetDataSource operation to verify that the status of the DataSource changed to DELETED.  Caution: The results of the DeleteDataSource operation are irreversible.

    Args:
        data_source_id(str): A user-supplied ID that uniquely identifies the DataSource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.data_source.init.delete(
                ctx, data_source_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.data_source.init.delete data_source_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="delete_data_source",
        op_kwargs={"DataSourceId": data_source_id},
    )


async def describe_all(
    hub,
    ctx,
    filter_variable: str = None,
    eq: str = None,
    gt: str = None,
    lt: str = None,
    ge: str = None,
    le: str = None,
    ne: str = None,
    prefix: str = None,
    sort_order: str = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of DataSource that match the search criteria in the request.

    Args:
        filter_variable(str, optional): Use one of the following variables to filter a list of DataSource:    CreatedAt - Sets the search criteria to DataSource creation dates.    Status - Sets the search criteria to DataSource statuses.    Name - Sets the search criteria to the contents of DataSource Name.    DataUri - Sets the search criteria to the URI of data files used to create the DataSource. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.    IAMUser - Sets the search criteria to the user account that invoked the DataSource creation.  . Defaults to None.
        eq(str, optional): The equal to operator. The DataSource results will have FilterVariable values that exactly match the value specified with EQ. Defaults to None.
        gt(str, optional): The greater than operator. The DataSource results will have FilterVariable values that are greater than the value specified with GT. Defaults to None.
        lt(str, optional): The less than operator. The DataSource results will have FilterVariable values that are less than the value specified with LT. Defaults to None.
        ge(str, optional): The greater than or equal to operator. The DataSource results will have FilterVariable values that are greater than or equal to the value specified with GE. . Defaults to None.
        le(str, optional): The less than or equal to operator. The DataSource results will have FilterVariable values that are less than or equal to the value specified with LE. Defaults to None.
        ne(str, optional): The not equal to operator. The DataSource results will have FilterVariable values not equal to the value specified with NE. Defaults to None.
        prefix(str, optional): A string that is found at the beginning of a variable, such as Name or Id. For example, a DataSource could have the Name 2014-09-09-HolidayGiftMailer. To search for this DataSource, select Name for the FilterVariable and any of the following strings for the Prefix:    2014-09   2014-09-09   2014-09-09-Holiday  . Defaults to None.
        sort_order(str, optional): A two-value parameter that determines the sequence of the resulting list of DataSource.    asc - Arranges the list in ascending order (A-Z, 0-9).    dsc - Arranges the list in descending order (Z-A, 9-0).   Results are sorted by FilterVariable. Defaults to None.
        next_token(str, optional): The ID of the page in the paginated results. Defaults to None.
        limit(int, optional):  The maximum number of DataSource to include in the result. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.data_source.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.data_source.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="describe_data_sources",
        op_kwargs={
            "FilterVariable": filter_variable,
            "EQ": eq,
            "GT": gt,
            "LT": lt,
            "GE": ge,
            "LE": le,
            "NE": ne,
            "Prefix": prefix,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def get(hub, ctx, data_source_id: str, verbose: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a DataSource that includes metadata and data file information, as well as the current status of the DataSource.  GetDataSource provides results in normal or verbose format. The verbose format adds the schema description and the list of files pointed to by the DataSource to the normal format.

    Args:
        data_source_id(str): The ID assigned to the DataSource at creation.
        verbose(bool, optional): Specifies whether the GetDataSource operation should return DataSourceSchema. If true, DataSourceSchema is returned. If false, DataSourceSchema is not returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.data_source.init.get(ctx, data_source_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.data_source.init.get data_source_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="get_data_source",
        op_kwargs={"DataSourceId": data_source_id, "Verbose": verbose},
    )


async def update(hub, ctx, data_source_id: str, data_source_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates the DataSourceName of a DataSource. You can use the GetDataSource operation to view the contents of the updated data element.

    Args:
        data_source_id(str): The ID assigned to the DataSource during creation.
        data_source_name(str): A new user-supplied name or description of the DataSource that will replace the current description. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.data_source.init.update(
                ctx, data_source_id=value, data_source_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.data_source.init.update data_source_id=value, data_source_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="update_data_source",
        op_kwargs={"DataSourceId": data_source_id, "DataSourceName": data_source_name},
    )
