"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    batch_prediction_id: str,
    ml_model_id: str,
    batch_prediction_data_source_id: str,
    output_uri: str,
    batch_prediction_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Generates predictions for a group of observations. The observations to process exist in one or more data files referenced by a DataSource. This operation creates a new BatchPrediction, and uses an MLModel and the data files referenced by the DataSource as information sources.   CreateBatchPrediction is an asynchronous operation. In response to CreateBatchPrediction, Amazon Machine Learning (Amazon ML) immediately returns and sets the BatchPrediction status to PENDING. After the BatchPrediction completes, Amazon ML sets the status to COMPLETED.  You can poll for status updates by using the GetBatchPrediction operation and checking the Status parameter of the result. After the COMPLETED status appears, the results are available in the location specified by the OutputUri parameter.

    Args:
        batch_prediction_id(str): A user-supplied ID that uniquely identifies the BatchPrediction.
        batch_prediction_name(str, optional): A user-supplied name or description of the BatchPrediction. BatchPredictionName can only use the UTF-8 character set. Defaults to None.
        ml_model_id(str): The ID of the MLModel that will generate predictions for the group of observations. .
        batch_prediction_data_source_id(str): The ID of the DataSource that points to the group of observations to predict.
        output_uri(str): The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch prediction results. The following substrings are not allowed in the s3 key portion of the outputURI field: ':', '//', '/./', '/../'. Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how to set permissions, see the Amazon Machine Learning Developer Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.batch_prediction.create(
                ctx,
                batch_prediction_id=value,
                ml_model_id=value,
                batch_prediction_data_source_id=value,
                output_uri=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.batch_prediction.create batch_prediction_id=value, ml_model_id=value, batch_prediction_data_source_id=value, output_uri=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="create_batch_prediction",
        op_kwargs={
            "BatchPredictionId": batch_prediction_id,
            "BatchPredictionName": batch_prediction_name,
            "MLModelId": ml_model_id,
            "BatchPredictionDataSourceId": batch_prediction_data_source_id,
            "OutputUri": output_uri,
        },
    )


async def delete(hub, ctx, batch_prediction_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Assigns the DELETED status to a BatchPrediction, rendering it unusable. After using the DeleteBatchPrediction operation, you can use the GetBatchPrediction operation to verify that the status of the BatchPrediction changed to DELETED.  Caution: The result of the DeleteBatchPrediction operation is irreversible.

    Args:
        batch_prediction_id(str): A user-supplied ID that uniquely identifies the BatchPrediction.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.batch_prediction.delete(
                ctx, batch_prediction_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.batch_prediction.delete batch_prediction_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="delete_batch_prediction",
        op_kwargs={"BatchPredictionId": batch_prediction_id},
    )


async def describe_all(
    hub,
    ctx,
    filter_variable: str = None,
    eq: str = None,
    gt: str = None,
    lt: str = None,
    ge: str = None,
    le: str = None,
    ne: str = None,
    prefix: str = None,
    sort_order: str = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of BatchPrediction operations that match the search criteria in the request.

    Args:
        filter_variable(str, optional): Use one of the following variables to filter a list of BatchPrediction:    CreatedAt - Sets the search criteria to the BatchPrediction creation date.    Status - Sets the search criteria to the BatchPrediction status.    Name - Sets the search criteria to the contents of the BatchPrediction   Name.    IAMUser - Sets the search criteria to the user account that invoked the BatchPrediction creation.    MLModelId - Sets the search criteria to the MLModel used in the BatchPrediction.    DataSourceId - Sets the search criteria to the DataSource used in the BatchPrediction.    DataURI - Sets the search criteria to the data file(s) used in the BatchPrediction. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.  . Defaults to None.
        eq(str, optional): The equal to operator. The BatchPrediction results will have FilterVariable values that exactly match the value specified with EQ. Defaults to None.
        gt(str, optional): The greater than operator. The BatchPrediction results will have FilterVariable values that are greater than the value specified with GT. Defaults to None.
        lt(str, optional): The less than operator. The BatchPrediction results will have FilterVariable values that are less than the value specified with LT. Defaults to None.
        ge(str, optional): The greater than or equal to operator. The BatchPrediction results will have FilterVariable values that are greater than or equal to the value specified with GE. . Defaults to None.
        le(str, optional): The less than or equal to operator. The BatchPrediction results will have FilterVariable values that are less than or equal to the value specified with LE. Defaults to None.
        ne(str, optional): The not equal to operator. The BatchPrediction results will have FilterVariable values not equal to the value specified with NE. Defaults to None.
        prefix(str, optional): A string that is found at the beginning of a variable, such as Name or Id. For example, a Batch Prediction operation could have the Name 2014-09-09-HolidayGiftMailer. To search for this BatchPrediction, select Name for the FilterVariable and any of the following strings for the Prefix:    2014-09   2014-09-09   2014-09-09-Holiday  . Defaults to None.
        sort_order(str, optional): A two-value parameter that determines the sequence of the resulting list of MLModels.    asc - Arranges the list in ascending order (A-Z, 0-9).    dsc - Arranges the list in descending order (Z-A, 9-0).   Results are sorted by FilterVariable. Defaults to None.
        next_token(str, optional): An ID of the page in the paginated results. Defaults to None.
        limit(int, optional): The number of pages of information to include in the result. The range of acceptable values is 1 through 100. The default value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.batch_prediction.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.batch_prediction.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="describe_batch_predictions",
        op_kwargs={
            "FilterVariable": filter_variable,
            "EQ": eq,
            "GT": gt,
            "LT": lt,
            "GE": ge,
            "LE": le,
            "NE": ne,
            "Prefix": prefix,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def get(hub, ctx, batch_prediction_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a BatchPrediction that includes detailed metadata, status, and data file information for a Batch Prediction request.

    Args:
        batch_prediction_id(str): An ID assigned to the BatchPrediction at creation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.batch_prediction.get(
                ctx, batch_prediction_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.batch_prediction.get batch_prediction_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="get_batch_prediction",
        op_kwargs={"BatchPredictionId": batch_prediction_id},
    )


async def update(
    hub, ctx, batch_prediction_id: str, batch_prediction_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the BatchPredictionName of a BatchPrediction. You can use the GetBatchPrediction operation to view the contents of the updated data element.

    Args:
        batch_prediction_id(str): The ID assigned to the BatchPrediction during creation.
        batch_prediction_name(str): A new user-supplied name or description of the BatchPrediction.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.batch_prediction.update(
                ctx, batch_prediction_id=value, batch_prediction_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.batch_prediction.update batch_prediction_id=value, batch_prediction_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="update_batch_prediction",
        op_kwargs={
            "BatchPredictionId": batch_prediction_id,
            "BatchPredictionName": batch_prediction_name,
        },
    )
