"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, project_name: str, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates an empty Amazon Lookout for Vision project. After you create the project, add a dataset by calling CreateDataset. This operation requires permissions to perform the lookoutvision:CreateProject operation.

    Args:
        project_name(str): The name for the project.
        client_token(str, optional): ClientToken is an idempotency token that ensures a call to CreateProject completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from CreateProject. In this case, safely retry your call to CreateProject by using the same ClientToken parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for ClientToken is considered a new call to CreateProject. An idempotency token is active for 8 hours. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutvision.project.create(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutvision.project.create project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutvision",
        operation="create_project",
        op_kwargs={"ProjectName": project_name, "ClientToken": client_token},
    )


async def delete(hub, ctx, project_name: str, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Amazon Lookout for Vision project. To delete a project, you must first delete each version of the model associated with the project. To delete a model use the DeleteModel operation. You also have to delete the dataset(s) associated with the model. For more information, see DeleteDataset. The images referenced by the training and test datasets aren't deleted.  This operation requires permissions to perform the lookoutvision:DeleteProject operation.

    Args:
        project_name(str): The name of the project to delete.
        client_token(str, optional): ClientToken is an idempotency token that ensures a call to DeleteProject completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from DeleteProject. In this case, safely retry your call to DeleteProject by using the same ClientToken parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for ClientToken is considered a new call to DeleteProject. An idempotency token is active for 8 hours. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutvision.project.delete(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutvision.project.delete project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutvision",
        operation="delete_project",
        op_kwargs={"ProjectName": project_name, "ClientToken": client_token},
    )


async def describe(hub, ctx, project_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an Amazon Lookout for Vision project. This operation requires permissions to perform the lookoutvision:DescribeProject operation.

    Args:
        project_name(str): The name of the project that you want to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutvision.project.describe(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutvision.project.describe project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutvision",
        operation="describe_project",
        op_kwargs={"ProjectName": project_name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Amazon Lookout for Vision projects in your AWS account. This operation requires permissions to perform the lookoutvision:ListProjects operation.

    Args:
        next_token(str, optional): If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of projects. Defaults to None.
        max_results(int, optional): The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutvision.project.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutvision.project.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutvision",
        operation="list_projects",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
