"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    project_name: str,
    output_config: Dict,
    description: str = None,
    client_token: str = None,
    kms_key_id: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new version of a model within an an Amazon Lookout for Vision project. CreateModel is an asynchronous operation in which Amazon Lookout for Vision trains, tests, and evaluates a new version of a model.  To get the current status, check the Status field returned in the response from DescribeModel. If the project has a single dataset, Amazon Lookout for Vision internally splits the dataset to create a training and a test dataset. If the project has a training and a test dataset, Lookout for Vision uses the respective datasets to train and test the model.  After training completes, the evaluation metrics are stored at the location specified in OutputConfig.  This operation requires permissions to perform the lookoutvision:CreateModel operation. If you want to tag your model, you also require permission to the lookoutvision:TagResource operation.

    Args:
        project_name(str): The name of the project in which you want to create a model version.
        description(str, optional): A description for the version of the model. Defaults to None.
        client_token(str, optional): ClientToken is an idempotency token that ensures a call to CreateModel completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from CreateModel. In this case, safely retry your call to CreateModel by using the same ClientToken parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for ClientToken is considered a new call to CreateModel. An idempotency token is active for 8 hours. Defaults to None.
        output_config(Dict): The location where Amazon Lookout for Vision saves the training results.
        kms_key_id(str, optional): The identifier for your AWS Key Management Service (AWS KMS) customer master key (CMK). The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. If this parameter is not specified, the copied images are encrypted by a key that AWS owns and manages. Defaults to None.
        tags(List, optional): A set of tags (key-value pairs) that you want to attach to the model. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutvision.model.create(
                ctx, project_name=value, output_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutvision.model.create project_name=value, output_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutvision",
        operation="create_model",
        op_kwargs={
            "ProjectName": project_name,
            "Description": description,
            "ClientToken": client_token,
            "OutputConfig": output_config,
            "KmsKeyId": kms_key_id,
            "Tags": tags,
        },
    )


async def delete(
    hub, ctx, project_name: str, model_version: str, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Amazon Lookout for Vision model. You can't delete a running model. To stop a running model, use the StopModel operation. It might take a few seconds to delete a model. To determine if a model has been deleted, call ListProjects and check if the version of the model (ModelVersion) is in the Models array.  This operation requires permissions to perform the lookoutvision:DeleteModel operation.

    Args:
        project_name(str): The name of the project that contains the model that you want to delete.
        model_version(str): The version of the model that you want to delete.
        client_token(str, optional): ClientToken is an idempotency token that ensures a call to DeleteModel completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from DeleteModel. In this case, safely retry your call to DeleteModel by using the same ClientToken parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for ClientToken is considered a new call to DeleteModel. An idempotency token is active for 8 hours. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutvision.model.delete(
                ctx, project_name=value, model_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutvision.model.delete project_name=value, model_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutvision",
        operation="delete_model",
        op_kwargs={
            "ProjectName": project_name,
            "ModelVersion": model_version,
            "ClientToken": client_token,
        },
    )


async def describe(hub, ctx, project_name: str, model_version: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a version of an Amazon Lookout for Vision model. This operation requires permissions to perform the lookoutvision:DescribeModel operation.

    Args:
        project_name(str): The project that contains the version of a model that you want to describe.
        model_version(str): The version of the model that you want to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutvision.model.describe(
                ctx, project_name=value, model_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutvision.model.describe project_name=value, model_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutvision",
        operation="describe_model",
        op_kwargs={"ProjectName": project_name, "ModelVersion": model_version},
    )


async def list_all(
    hub, ctx, project_name: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the versions of a model in an Amazon Lookout for Vision project. This operation requires permissions to perform the lookoutvision:ListModels operation.

    Args:
        project_name(str): The name of the project that contains the model versions that you want to list.
        next_token(str, optional): If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of models. Defaults to None.
        max_results(int, optional): The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutvision.model.list_all(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutvision.model.list_all project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutvision",
        operation="list_models",
        op_kwargs={
            "ProjectName": project_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def start(
    hub,
    ctx,
    project_name: str,
    model_version: str,
    min_inference_units: int,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts the running of the version of an Amazon Lookout for Vision model. Starting a model takes a while to complete. To check the current state of the model, use DescribeModel. A model is ready to use when its status is HOSTED. Once the model is running, you can detect custom labels in new images by calling DetectAnomalies.  You are charged for the amount of time that the model is running. To stop a running model, call StopModel.  This operation requires permissions to perform the lookoutvision:StartModel operation.

    Args:
        project_name(str): The name of the project that contains the model that you want to start.
        model_version(str): The version of the model that you want to start.
        min_inference_units(int): The minimum number of inference units to use. A single inference unit represents 1 hour of processing and can support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use. .
        client_token(str, optional): ClientToken is an idempotency token that ensures a call to StartModel completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from StartModel. In this case, safely retry your call to StartModel by using the same ClientToken parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for ClientToken is considered a new call to StartModel. An idempotency token is active for 8 hours. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutvision.model.start(
                ctx, project_name=value, model_version=value, min_inference_units=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutvision.model.start project_name=value, model_version=value, min_inference_units=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutvision",
        operation="start_model",
        op_kwargs={
            "ProjectName": project_name,
            "ModelVersion": model_version,
            "MinInferenceUnits": min_inference_units,
            "ClientToken": client_token,
        },
    )


async def stop(
    hub, ctx, project_name: str, model_version: str, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Stops the hosting of a running model. The operation might take a while to complete. To check the current status, call DescribeModel.  After the model hosting stops, the Status of the model is TRAINED. This operation requires permissions to perform the lookoutvision:StopModel operation.

    Args:
        project_name(str): The name of the project that contains the model that you want to stop.
        model_version(str): The version of the model that you want to stop.
        client_token(str, optional): ClientToken is an idempotency token that ensures a call to StopModel completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from StopModel. In this case, safely retry your call to StopModel by using the same ClientToken parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for ClientToken is considered a new call to StopModel. An idempotency token is active for 8 hours. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutvision.model.stop(
                ctx, project_name=value, model_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutvision.model.stop project_name=value, model_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutvision",
        operation="stop_model",
        op_kwargs={
            "ProjectName": project_name,
            "ModelVersion": model_version,
            "ClientToken": client_token,
        },
    )
