"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    project_name: str,
    dataset_type: str,
    dataset_source: Dict = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new dataset in an Amazon Lookout for Vision project. CreateDataset can create a training or a test dataset from a valid dataset source (DatasetSource). If you want a single dataset project, specify train for the value of DatasetType. To have a project with separate training and test datasets, call CreateDataset twice. On the first call, specify train for the value of DatasetType. On the second call, specify test for the value of DatasetType.  This operation requires permissions to perform the lookoutvision:CreateDataset operation.

    Args:
        project_name(str): The name of the project in which you want to create a dataset.
        dataset_type(str): The type of the dataset. Specify train for a training dataset. Specify test for a test dataset.
        dataset_source(Dict, optional): The location of the manifest file that Amazon Lookout for Vision uses to create the dataset. If you don't specify DatasetSource, an empty dataset is created and the operation synchronously returns. Later, you can add JSON Lines by calling UpdateDatasetEntries.  If you specify a value for DataSource, the manifest at the S3 location is validated and used to create the dataset. The call to CreateDataset is asynchronous and might take a while to complete. To find out the current status, Check the value of Status returned in a call to DescribeDataset. Defaults to None.
        client_token(str, optional): ClientToken is an idempotency token that ensures a call to CreateDataset completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from CreateDataset. In this case, safely retry your call to CreateDataset by using the same ClientToken parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for ClientToken is considered a new call to CreateDataset. An idempotency token is active for 8 hours. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutvision.dataset.init.create(
                ctx, project_name=value, dataset_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutvision.dataset.init.create project_name=value, dataset_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutvision",
        operation="create_dataset",
        op_kwargs={
            "ProjectName": project_name,
            "DatasetType": dataset_type,
            "DatasetSource": dataset_source,
            "ClientToken": client_token,
        },
    )


async def delete(
    hub, ctx, project_name: str, dataset_type: str, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing Amazon Lookout for Vision dataset.  If your the project has a single dataset, you must create a new dataset before you can create a model. If you project has a training dataset and a test dataset consider the following.    If you delete the test dataset, your project reverts to a single dataset project. If you then train the model, Amazon Lookout for Vision internally splits the remaining dataset into a training and test dataset.   If you delete the training dataset, you must create a training dataset before you can create a model.   This operation requires permissions to perform the lookoutvision:DeleteDataset operation.

    Args:
        project_name(str): The name of the project that contains the dataset that you want to delete.
        dataset_type(str): The type of the dataset to delete. Specify train to delete the training dataset. Specify test to delete the test dataset. To delete the dataset in a single dataset project, specify train.
        client_token(str, optional): ClientToken is an idempotency token that ensures a call to DeleteDataset completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from DeleteDataset. In this case, safely retry your call to DeleteDataset by using the same ClientToken parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for ClientToken is considered a new call to DeleteDataset. An idempotency token is active for 8 hours. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutvision.dataset.init.delete(
                ctx, project_name=value, dataset_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutvision.dataset.init.delete project_name=value, dataset_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutvision",
        operation="delete_dataset",
        op_kwargs={
            "ProjectName": project_name,
            "DatasetType": dataset_type,
            "ClientToken": client_token,
        },
    )


async def describe(hub, ctx, project_name: str, dataset_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Describe an Amazon Lookout for Vision dataset. This operation requires permissions to perform the lookoutvision:DescribeDataset operation.

    Args:
        project_name(str): The name of the project that contains the dataset that you want to describe.
        dataset_type(str): The type of the dataset to describe. Specify train to describe the training dataset. Specify test to describe the test dataset. If you have a single dataset project, specify train .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutvision.dataset.init.describe(
                ctx, project_name=value, dataset_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutvision.dataset.init.describe project_name=value, dataset_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutvision",
        operation="describe_dataset",
        op_kwargs={"ProjectName": project_name, "DatasetType": dataset_type},
    )
