"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def detect(
    hub, ctx, project_name: str, model_version: str, body: bytes, content_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Detects anomalies in an image that you supply.  The response from DetectAnomalies includes a boolean prediction that the image contains one or more anomalies and a confidence value for the prediction.  Before calling DetectAnomalies, you must first start your model with the StartModel operation. You are charged for the amount of time, in minutes, that a model runs and for the number of anomaly detection units that your model uses. If you are not using a model, use the StopModel operation to stop your model.   This operation requires permissions to perform the lookoutvision:DetectAnomalies operation.

    Args:
        project_name(str): The name of the project that contains the model version that you want to use.
        model_version(str): The version of the model that you want to use.
        body(bytes): The unencrypted image bytes that you want to analyze. .
        content_type(str): The type of the image passed in Body. Valid values are image/png (PNG format images) and image/jpeg (JPG format images). .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutvision.anomaly.detect(
                ctx, project_name=value, model_version=value, body=value, content_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutvision.anomaly.detect project_name=value, model_version=value, body=value, content_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutvision",
        operation="detect_anomalies",
        op_kwargs={
            "ProjectName": project_name,
            "ModelVersion": model_version,
            "Body": body,
            "ContentType": content_type,
        },
    )
