"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def back(hub, ctx, anomaly_detector_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Runs a backtest for anomaly detection for the specified resource.

    Args:
        anomaly_detector_arn(str): The Amazon Resource Name (ARN) of the anomaly detector.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutmetric.test_anomaly_detector.back(
                ctx, anomaly_detector_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutmetric.test_anomaly_detector.back anomaly_detector_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutmetrics",
        operation="back_test_anomaly_detector",
        op_kwargs={"AnomalyDetectorArn": anomaly_detector_arn},
    )
