"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, s3_source_config: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a selection of sample records from an Amazon S3 datasource.

    Args:
        s3_source_config(Dict, optional): A datasource bucket in Amazon S3. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutmetric.sample_data.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutmetric.sample_data.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutmetrics",
        operation="get_sample_data",
        op_kwargs={"S3SourceConfig": s3_source_config},
    )
