"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "metric_set"


async def create(
    hub,
    ctx,
    anomaly_detector_arn: str,
    metric_set_name: str,
    metric_list: List,
    metric_source: Dict,
    metric_set_description: str = None,
    offset: int = None,
    timestamp_column: Dict = None,
    dimension_list: List = None,
    metric_set_frequency: str = None,
    timezone: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a dataset.

    Args:
        anomaly_detector_arn(str): The ARN of the anomaly detector that will use the dataset.
        metric_set_name(str): The name of the dataset.
        metric_set_description(str, optional): A description of the dataset you are creating. Defaults to None.
        metric_list(List): A list of metrics that the dataset will contain.
        offset(int, optional): After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources. Defaults to None.
        timestamp_column(Dict, optional): Contains information about the column used for tracking time in your source data. Defaults to None.
        dimension_list(List, optional): A list of the fields you want to treat as dimensions. Defaults to None.
        metric_set_frequency(str, optional): The frequency with which the source data will be analyzed for anomalies. Defaults to None.
        metric_source(Dict): Contains information about how the source data should be interpreted.
        timezone(str, optional): The time zone in which your source data was recorded. Defaults to None.
        tags(Dict, optional): A list of tags to apply to the dataset. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutmetric.metric_set_.create(
                ctx,
                anomaly_detector_arn=value,
                metric_set_name=value,
                metric_list=value,
                metric_source=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutmetric.metric_set.create anomaly_detector_arn=value, metric_set_name=value, metric_list=value, metric_source=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutmetrics",
        operation="create_metric_set",
        op_kwargs={
            "AnomalyDetectorArn": anomaly_detector_arn,
            "MetricSetName": metric_set_name,
            "MetricSetDescription": metric_set_description,
            "MetricList": metric_list,
            "Offset": offset,
            "TimestampColumn": timestamp_column,
            "DimensionList": dimension_list,
            "MetricSetFrequency": metric_set_frequency,
            "MetricSource": metric_source,
            "Timezone": timezone,
            "Tags": tags,
        },
    )


async def describe(hub, ctx, metric_set_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a dataset. Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.

    Args:
        metric_set_arn(str): The ARN of the dataset.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutmetric.metric_set_.describe(ctx, metric_set_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutmetric.metric_set.describe metric_set_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutmetrics",
        operation="describe_metric_set",
        op_kwargs={"MetricSetArn": metric_set_arn},
    )


async def list_all(
    hub,
    ctx,
    anomaly_detector_arn: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the datasets in the current AWS Region. Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.

    Args:
        anomaly_detector_arn(str, optional): The ARN of the anomaly detector containing the metrics sets to list. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): If the result of the previous request was truncated, the response includes a NextToken. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutmetric.metric_set_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutmetric.metric_set.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutmetrics",
        operation="list_metric_sets",
        op_kwargs={
            "AnomalyDetectorArn": anomaly_detector_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    metric_set_arn: str,
    metric_set_description: str = None,
    metric_list: List = None,
    offset: int = None,
    timestamp_column: Dict = None,
    dimension_list: List = None,
    metric_set_frequency: str = None,
    metric_source: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a dataset.

    Args:
        metric_set_arn(str): The ARN of the dataset to update.
        metric_set_description(str, optional): The dataset's description. Defaults to None.
        metric_list(List, optional): The metric list. Defaults to None.
        offset(int, optional): After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources. Defaults to None.
        timestamp_column(Dict, optional): The timestamp column. Defaults to None.
        dimension_list(List, optional): The dimension list. Defaults to None.
        metric_set_frequency(str, optional): The dataset's interval. Defaults to None.
        metric_source(Dict, optional): Contains information about source data used to generate a metric. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutmetric.metric_set_.update(ctx, metric_set_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutmetric.metric_set.update metric_set_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutmetrics",
        operation="update_metric_set",
        op_kwargs={
            "MetricSetArn": metric_set_arn,
            "MetricSetDescription": metric_set_description,
            "MetricList": metric_list,
            "Offset": offset,
            "TimestampColumn": timestamp_column,
            "DimensionList": dimension_list,
            "MetricSetFrequency": metric_set_frequency,
            "MetricSource": metric_source,
        },
    )
