"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    anomaly_detector_arn: str,
    anomaly_group_time_series_feedback: Dict,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Get feedback for an anomaly group.

    Args:
        anomaly_detector_arn(str): The Amazon Resource Name (ARN) of the anomaly detector.
        anomaly_group_time_series_feedback(Dict): The anomalous metric and group ID.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): Specify the pagination token that's returned by a previous request to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutmetric.feedback.get(
                ctx, anomaly_detector_arn=value, anomaly_group_time_series_feedback=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutmetric.feedback.get anomaly_detector_arn=value, anomaly_group_time_series_feedback=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutmetrics",
        operation="get_feedback",
        op_kwargs={
            "AnomalyDetectorArn": anomaly_detector_arn,
            "AnomalyGroupTimeSeriesFeedback": anomaly_group_time_series_feedback,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def put(
    hub, ctx, anomaly_detector_arn: str, anomaly_group_time_series_feedback: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Add feedback for an anomalous metric.

    Args:
        anomaly_detector_arn(str): The Amazon Resource Name (ARN) of the anomaly detector.
        anomaly_group_time_series_feedback(Dict): Feedback for an anomalous metric.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutmetric.feedback.put(
                ctx, anomaly_detector_arn=value, anomaly_group_time_series_feedback=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutmetric.feedback.put anomaly_detector_arn=value, anomaly_group_time_series_feedback=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutmetrics",
        operation="put_feedback",
        op_kwargs={
            "AnomalyDetectorArn": anomaly_detector_arn,
            "AnomalyGroupTimeSeriesFeedback": anomaly_group_time_series_feedback,
        },
    )
