"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    anomaly_detector_arn: str,
    anomaly_group_id: str,
    metric_name: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of anomalous metrics for a measure in an anomaly group.

    Args:
        anomaly_detector_arn(str): The Amazon Resource Name (ARN) of the anomaly detector.
        anomaly_group_id(str): The ID of the anomaly group.
        metric_name(str): The name of the measure field.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): Specify the pagination token that's returned by a previous request to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutmetric.anomaly.group.time_sery.list_all(
                ctx, anomaly_detector_arn=value, anomaly_group_id=value, metric_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutmetric.anomaly.group.time_sery.list_all anomaly_detector_arn=value, anomaly_group_id=value, metric_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutmetrics",
        operation="list_anomaly_group_time_series",
        op_kwargs={
            "AnomalyDetectorArn": anomaly_detector_arn,
            "AnomalyGroupId": anomaly_group_id,
            "MetricName": metric_name,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
