"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    anomaly_detector_arn: str,
    sensitivity_threshold: int,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of anomaly groups.

    Args:
        anomaly_detector_arn(str): The Amazon Resource Name (ARN) of the anomaly detector.
        sensitivity_threshold(int): The minimum severity score for inclusion in the output.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): Specify the pagination token that's returned by a previous request to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutmetric.anomaly.group.summary.list_all(
                ctx, anomaly_detector_arn=value, sensitivity_threshold=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutmetric.anomaly.group.summary.list_all anomaly_detector_arn=value, sensitivity_threshold=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutmetrics",
        operation="list_anomaly_group_summaries",
        op_kwargs={
            "AnomalyDetectorArn": anomaly_detector_arn,
            "SensitivityThreshold": sensitivity_threshold,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
