"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, anomaly_group_id: str, anomaly_detector_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns details about a group of anomalous metrics.

    Args:
        anomaly_group_id(str): The ID of the anomaly group.
        anomaly_detector_arn(str): The Amazon Resource Name (ARN) of the anomaly detector.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutmetric.anomaly.group.init.get(
                ctx, anomaly_group_id=value, anomaly_detector_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutmetric.anomaly.group.init.get anomaly_group_id=value, anomaly_detector_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutmetrics",
        operation="get_anomaly_group",
        op_kwargs={
            "AnomalyGroupId": anomaly_group_id,
            "AnomalyDetectorArn": anomaly_detector_arn,
        },
    )
