"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    anomaly_detector_arn: str,
    timestamp: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the status of the specified anomaly detection jobs.

    Args:
        anomaly_detector_arn(str): The Amazon Resource Name (ARN) of the anomaly detector.
        timestamp(str, optional): The timestamp of the anomaly detection job. Defaults to None.
        max_results(int, optional): The number of items to return in the response. Defaults to None.
        next_token(str, optional): Specify the pagination token that's returned by a previous request to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutmetric.anomaly.detection_execution.describe_all(
                ctx, anomaly_detector_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutmetric.anomaly.detection_execution.describe_all anomaly_detector_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutmetrics",
        operation="describe_anomaly_detection_executions",
        op_kwargs={
            "AnomalyDetectorArn": anomaly_detector_arn,
            "Timestamp": timestamp,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
