"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    model_name: str,
    dataset_name: str,
    client_token: str,
    dataset_schema: Dict = None,
    labels_input_configuration: Dict = None,
    training_data_start_time: str = None,
    training_data_end_time: str = None,
    evaluation_data_start_time: str = None,
    evaluation_data_end_time: str = None,
    role_arn: str = None,
    data_pre_processing_configuration: Dict = None,
    server_side_kms_key_id: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an ML model for data inference.  A machine-learning (ML) model is a mathematical model that finds patterns in your data. In Amazon Lookout for Equipment, the model learns the patterns of normal behavior and detects abnormal behavior that could be potential equipment failure (or maintenance events). The models are made by analyzing normal data and abnormalities in machine behavior that have already occurred. Your model is trained using a portion of the data from your dataset and uses that data to learn patterns of normal behavior and abnormal patterns that lead to equipment failure. Another portion of the data is used to evaluate the model's accuracy.

    Args:
        model_name(str): The name for the ML model to be created.
        dataset_name(str): The name of the dataset for the ML model being created. .
        dataset_schema(Dict, optional): The data schema for the ML model being created. . Defaults to None.
        labels_input_configuration(Dict, optional): The input configuration for the labels being used for the ML model that's being created. . Defaults to None.
        client_token(str): A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. .
        training_data_start_time(str, optional): Indicates the time reference in the dataset that should be used to begin the subset of training data for the ML model. . Defaults to None.
        training_data_end_time(str, optional): Indicates the time reference in the dataset that should be used to end the subset of training data for the ML model. . Defaults to None.
        evaluation_data_start_time(str, optional): Indicates the time reference in the dataset that should be used to begin the subset of evaluation data for the ML model. . Defaults to None.
        evaluation_data_end_time(str, optional):  Indicates the time reference in the dataset that should be used to end the subset of evaluation data for the ML model. . Defaults to None.
        role_arn(str, optional):  The Amazon Resource Name (ARN) of a role with permission to access the data source being used to create the ML model. . Defaults to None.
        data_pre_processing_configuration(Dict, optional): The configuration is the TargetSamplingRate, which is the sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1 second level and you want the system to resample the data at a 1 minute rate before training, the TargetSamplingRate is 1 minute. When providing a value for the TargetSamplingRate, you must attach the prefix "PT" to the rate you want. The value for a 1 second rate is therefore PT1S, the value for a 15 minute rate is PT15M, and the value for a 1 hour rate is PT1H . Defaults to None.
        server_side_kms_key_id(str, optional): Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt model data by Amazon Lookout for Equipment. . Defaults to None.
        tags(List, optional):  Any tags associated with the ML model being created. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutequipment.model.create(
                ctx, model_name=value, dataset_name=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutequipment.model.create model_name=value, dataset_name=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutequipment",
        operation="create_model",
        op_kwargs={
            "ModelName": model_name,
            "DatasetName": dataset_name,
            "DatasetSchema": dataset_schema,
            "LabelsInputConfiguration": labels_input_configuration,
            "ClientToken": client_token,
            "TrainingDataStartTime": training_data_start_time,
            "TrainingDataEndTime": training_data_end_time,
            "EvaluationDataStartTime": evaluation_data_start_time,
            "EvaluationDataEndTime": evaluation_data_end_time,
            "RoleArn": role_arn,
            "DataPreProcessingConfiguration": data_pre_processing_configuration,
            "ServerSideKmsKeyId": server_side_kms_key_id,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, model_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an ML model currently available for Amazon Lookout for Equipment. This will prevent it from being used with an inference scheduler, even one that is already set up.

    Args:
        model_name(str): The name of the ML model to be deleted. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutequipment.model.delete(ctx, model_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutequipment.model.delete model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutequipment",
        operation="delete_model",
        op_kwargs={"ModelName": model_name},
    )


async def describe(hub, ctx, model_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides overall information about a specific ML model, including model name and ARN, dataset, training and evaluation information, status, and so on.

    Args:
        model_name(str): The name of the ML model to be described. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutequipment.model.describe(ctx, model_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutequipment.model.describe model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutequipment",
        operation="describe_model",
        op_kwargs={"ModelName": model_name},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    status: str = None,
    model_name_begins_with: str = None,
    dataset_name_begins_with: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Generates a list of all models in the account, including model name and ARN, dataset, and status.

    Args:
        next_token(str, optional):  An opaque pagination token indicating where to continue the listing of ML models. . Defaults to None.
        max_results(int, optional):  Specifies the maximum number of ML models to list. . Defaults to None.
        status(str, optional): The status of the ML model. . Defaults to None.
        model_name_begins_with(str, optional): The beginning of the name of the ML models being listed. . Defaults to None.
        dataset_name_begins_with(str, optional): The beginning of the name of the dataset of the ML models to be listed. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutequipment.model.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutequipment.model.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutequipment",
        operation="list_models",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Status": status,
            "ModelNameBeginsWith": model_name_begins_with,
            "DatasetNameBeginsWith": dataset_name_begins_with,
        },
    )
