"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    inference_scheduler_name: str,
    next_token: str = None,
    max_results: int = None,
    data_start_time_after: str = None,
    data_end_time_before: str = None,
    status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Lists all inference executions that have been performed by the specified inference scheduler.

    Args:
        next_token(str, optional): An opaque pagination token indicating where to continue the listing of inference executions. Defaults to None.
        max_results(int, optional): Specifies the maximum number of inference executions to list. . Defaults to None.
        inference_scheduler_name(str): The name of the inference scheduler for the inference execution listed. .
        data_start_time_after(str, optional): The time reference in the inferenced dataset after which Amazon Lookout for Equipment started the inference execution. . Defaults to None.
        data_end_time_before(str, optional): The time reference in the inferenced dataset before which Amazon Lookout for Equipment stopped the inference execution. . Defaults to None.
        status(str, optional): The status of the inference execution. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutequipment.inference.execution.list_all(
                ctx, inference_scheduler_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutequipment.inference.execution.list_all inference_scheduler_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutequipment",
        operation="list_inference_executions",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "InferenceSchedulerName": inference_scheduler_name,
            "DataStartTimeAfter": data_start_time_after,
            "DataEndTimeBefore": data_end_time_before,
            "Status": status,
        },
    )
