"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    dataset_name: str,
    dataset_schema: Dict,
    client_token: str,
    server_side_kms_key_id: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a container for a collection of data being ingested for analysis. The dataset contains the metadata describing where the data is and what the data actually looks like. In other words, it contains the location of the data source, the data schema, and other information. A dataset also contains any tags associated with the ingested data.

    Args:
        dataset_name(str): The name of the dataset being created. .
        dataset_schema(Dict): A JSON description of the data that is in each time series dataset, including names, column names, and data types. .
        server_side_kms_key_id(str, optional): Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt dataset data by Amazon Lookout for Equipment. . Defaults to None.
        client_token(str):  A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. .
        tags(List, optional): Any tags associated with the ingested data described in the dataset. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutequipment.dataset.create(
                ctx, dataset_name=value, dataset_schema=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutequipment.dataset.create dataset_name=value, dataset_schema=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutequipment",
        operation="create_dataset",
        op_kwargs={
            "DatasetName": dataset_name,
            "DatasetSchema": dataset_schema,
            "ServerSideKmsKeyId": server_side_kms_key_id,
            "ClientToken": client_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, dataset_name: str) -> None:
    r"""
    **Autogenerated function**

     Deletes a dataset and associated artifacts. The operation will check to see if any inference scheduler or data ingestion job is currently using the dataset, and if there isn't, the dataset, its metadata, and any associated data stored in S3 will be deleted. This does not affect any models that used this dataset for training and evaluation, but does prevent it from being used in the future.

    Args:
        dataset_name(str): The name of the dataset to be deleted. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutequipment.dataset.delete(ctx, dataset_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutequipment.dataset.delete dataset_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutequipment",
        operation="delete_dataset",
        op_kwargs={"DatasetName": dataset_name},
    )


async def describe(hub, ctx, dataset_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides information on a specified dataset such as the schema location, status, and so on.

    Args:
        dataset_name(str): The name of the dataset to be described. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutequipment.dataset.describe(ctx, dataset_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutequipment.dataset.describe dataset_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutequipment",
        operation="describe_dataset",
        op_kwargs={"DatasetName": dataset_name},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    dataset_name_begins_with: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all datasets currently available in your account, filtering on the dataset name.

    Args:
        next_token(str, optional):  An opaque pagination token indicating where to continue the listing of datasets. . Defaults to None.
        max_results(int, optional):  Specifies the maximum number of datasets to list. . Defaults to None.
        dataset_name_begins_with(str, optional): The beginning of the name of the datasets to be listed. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutequipment.dataset.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutequipment.dataset.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutequipment",
        operation="list_datasets",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "DatasetNameBeginsWith": dataset_name_begins_with,
        },
    )
