"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides information on a specific data ingestion job such as creation time, dataset ARN, status, and so on.

    Args:
        job_id(str): The job ID of the data ingestion job. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutequipment.data.ingestion_job.describe(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutequipment.data.ingestion_job.describe job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutequipment",
        operation="describe_data_ingestion_job",
        op_kwargs={"JobId": job_id},
    )


async def list_all(
    hub,
    ctx,
    dataset_name: str = None,
    next_token: str = None,
    max_results: int = None,
    status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of all data ingestion jobs, including dataset name and ARN, S3 location of the input data, status, and so on.

    Args:
        dataset_name(str, optional): The name of the dataset being used for the data ingestion job. . Defaults to None.
        next_token(str, optional):  An opaque pagination token indicating where to continue the listing of data ingestion jobs. . Defaults to None.
        max_results(int, optional):  Specifies the maximum number of data ingestion jobs to list. . Defaults to None.
        status(str, optional): Indicates the status of the data ingestion job. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutequipment.data.ingestion_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutequipment.data.ingestion_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutequipment",
        operation="list_data_ingestion_jobs",
        op_kwargs={
            "DatasetName": dataset_name,
            "NextToken": next_token,
            "MaxResults": max_results,
            "Status": status,
        },
    )


async def start(
    hub,
    ctx,
    dataset_name: str,
    ingestion_input_configuration: Dict,
    role_arn: str,
    client_token: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a data ingestion job. Amazon Lookout for Equipment returns the job status.

    Args:
        dataset_name(str): The name of the dataset being used by the data ingestion job. .
        ingestion_input_configuration(Dict):  Specifies information for the input data for the data ingestion job, including dataset S3 location. .
        role_arn(str):  The Amazon Resource Name (ARN) of a role with permission to access the data source for the data ingestion job. .
        client_token(str):  A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lookoutequipment.data.ingestion_job.start(
                ctx,
                dataset_name=value,
                ingestion_input_configuration=value,
                role_arn=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lookoutequipment.data.ingestion_job.start dataset_name=value, ingestion_input_configuration=value, role_arn=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lookoutequipment",
        operation="start_data_ingestion_job",
        op_kwargs={
            "DatasetName": dataset_name,
            "IngestionInputConfiguration": ingestion_input_configuration,
            "RoleArn": role_arn,
            "ClientToken": client_token,
        },
    )
