"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, log_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists the tags for the specified log group.

    Args:
        log_group_name(str): The name of the log group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.tags_log_group.list(ctx, log_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.tags_log_group.list log_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="list_tags_log_group",
        op_kwargs={"logGroupName": log_group_name},
    )
