"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "subscription_filter"


async def delete(hub, ctx, log_group_name: str, filter_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified subscription filter.

    Args:
        log_group_name(str): The name of the log group.
        filter_name(str): The name of the subscription filter.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.subscription_filter_.delete(
                ctx, log_group_name=value, filter_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.subscription_filter.delete log_group_name=value, filter_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="delete_subscription_filter",
        op_kwargs={"logGroupName": log_group_name, "filterName": filter_name},
    )


async def describe_all(
    hub,
    ctx,
    log_group_name: str,
    filter_name_prefix: str = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the subscription filters for the specified log group. You can list all the subscription filters or filter the results by prefix. The results are ASCII-sorted by filter name.

    Args:
        log_group_name(str): The name of the log group.
        filter_name_prefix(str, optional): The prefix to match. If you don't specify a value, no prefix filter is applied. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        limit(int, optional): The maximum number of items returned. If you don't specify a value, the default is up to 50 items. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.subscription_filter_.describe_all(
                ctx, log_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.subscription_filter.describe_all log_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="describe_subscription_filters",
        op_kwargs={
            "logGroupName": log_group_name,
            "filterNamePrefix": filter_name_prefix,
            "nextToken": next_token,
            "limit": limit,
        },
    )


async def put(
    hub,
    ctx,
    log_group_name: str,
    filter_name: str,
    filter_pattern: str,
    destination_arn: str,
    role_arn: str = None,
    distribution: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Creates or updates a subscription filter and associates it with the specified log group. Subscription filters allow you to subscribe to a real-time stream of log events ingested through PutLogEvents and have them delivered to a specific destination. When log events are sent to the receiving service, they are Base64 encoded and compressed with the gzip format. The following destinations are supported for subscription filters:   An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.   A logical destination that belongs to a different account, for cross-account delivery.   An Amazon Kinesis Firehose delivery stream that belongs to the same account as the subscription filter, for same-account delivery.   An AWS Lambda function that belongs to the same account as the subscription filter, for same-account delivery.   Each log group can have up to two subscription filters associated with it. If you are updating an existing filter, you must specify the correct name in filterName.  To perform a PutSubscriptionFilter operation, you must also have the iam:PassRole permission.

    Args:
        log_group_name(str): The name of the log group.
        filter_name(str): A name for the subscription filter. If you are updating an existing filter, you must specify the correct name in filterName. To find the name of the filter currently associated with a log group, use DescribeSubscriptionFilters.
        filter_pattern(str): A filter pattern for subscribing to a filtered stream of log events.
        destination_arn(str): The ARN of the destination to deliver matching log events to. Currently, the supported destinations are:   An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.   A logical destination (specified using an ARN) belonging to a different account, for cross-account delivery. If you are setting up a cross-account subscription, the destination must have an IAM policy associated with it that allows the sender to send logs to the destination. For more information, see PutDestinationPolicy.   An Amazon Kinesis Firehose delivery stream belonging to the same account as the subscription filter, for same-account delivery.   An AWS Lambda function belonging to the same account as the subscription filter, for same-account delivery.  .
        role_arn(str, optional): The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination stream. You don't need to provide the ARN when you are working with a logical destination for cross-account delivery. Defaults to None.
        distribution(str, optional): The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the grouping can be set to random for a more even distribution. This property is only applicable when the destination is an Amazon Kinesis stream. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.subscription_filter_.put(
                ctx,
                log_group_name=value,
                filter_name=value,
                filter_pattern=value,
                destination_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.subscription_filter.put log_group_name=value, filter_name=value, filter_pattern=value, destination_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="put_subscription_filter",
        op_kwargs={
            "logGroupName": log_group_name,
            "filterName": filter_name,
            "filterPattern": filter_pattern,
            "destinationArn": destination_arn,
            "roleArn": role_arn,
            "distribution": distribution,
        },
    )
