"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def delete(hub, ctx, log_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified retention policy. Log events do not expire if they belong to log groups without a retention policy.

    Args:
        log_group_name(str): The name of the log group.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.retention_policy.delete(ctx, log_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.retention_policy.delete log_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="delete_retention_policy",
        op_kwargs={"logGroupName": log_group_name},
    )


async def put(hub, ctx, log_group_name: str, retention_in_days: int) -> None:
    r"""
    **Autogenerated function**

    Sets the retention of the specified log group. A retention policy allows you to configure the number of days for which to retain log events in the specified log group.

    Args:
        log_group_name(str): The name of the log group.
        retention_in_days(int): The number of days to retain the log events in the specified log group. Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1827, and 3653. If you omit retentionInDays in a PutRetentionPolicy operation, the events in the log group are always retained and never expire.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.retention_policy.put(
                ctx, log_group_name=value, retention_in_days=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.retention_policy.put log_group_name=value, retention_in_days=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="put_retention_policy",
        op_kwargs={
            "logGroupName": log_group_name,
            "retentionInDays": retention_in_days,
        },
    )
