"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, policy_name: str = None) -> None:
    r"""
    **Autogenerated function**

    Deletes a resource policy from this account. This revokes the access of the identities in that policy to put log events to this account.

    Args:
        policy_name(str, optional): The name of the policy to be revoked. This parameter is required. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.resource_policy.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.resource_policy.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="delete_resource_policy",
        op_kwargs={"policyName": policy_name},
    )


async def describe_all(hub, ctx, next_token: str = None, limit: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the resource policies in this account.

    Args:
        next_token(str, optional): The token for the next set of items to return. The token expires after 24 hours. Defaults to None.
        limit(int, optional): The maximum number of resource policies to be displayed with one call of this API. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.resource_policy.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.resource_policy.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="describe_resource_policies",
        op_kwargs={"nextToken": next_token, "limit": limit},
    )


async def put(hub, ctx, policy_name: str = None, policy_document: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates a resource policy allowing other AWS services to put log events to this account, such as Amazon Route 53. An account can have up to 10 resource policies per AWS Region.

    Args:
        policy_name(str, optional): Name of the new policy. This parameter is required. Defaults to None.
        policy_document(str, optional): Details of the new policy, including the identity of the principal that is enabled to put logs to this account. This is formatted as a JSON string. This parameter is required. The following example creates a resource policy enabling the Route 53 service to put DNS query logs in to the specified log group. Replace "logArn" with the ARN of your CloudWatch Logs resource, such as a log group or log stream.  { "Version": "2012-10-17", "Statement": [ { "Sid": "Route53LogsToCloudWatchLogs", "Effect": "Allow", "Principal": { "Service": [ "route53.amazonaws.com" ] }, "Action":"logs:PutLogEvents", "Resource": "logArn" } ] }  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.resource_policy.put(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.resource_policy.put
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="put_resource_policy",
        op_kwargs={"policyName": policy_name, "policyDocument": policy_document},
    )
