"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, query_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the results from the specified query. Only the fields requested in the query are returned, along with a @ptr field, which is the identifier for the log record. You can use the value of @ptr in a GetLogRecord operation to get the full log record.  GetQueryResults does not start a query execution. To run a query, use StartQuery. If the value of the Status field in the output is Running, this operation returns only partial results. If you see a value of Scheduled or Running for the status, you can retry the operation later to see the final results.

    Args:
        query_id(str): The ID number of the query.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.query.result.get_all(ctx, query_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.query.result.get_all query_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="get_query_results",
        op_kwargs={"queryId": query_id},
    )
