"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    log_group_name: str = None,
    status: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of CloudWatch Logs Insights queries that are scheduled, executing, or have been executed recently in this account. You can request all queries or limit it to queries of a specific log group or queries with a certain status.

    Args:
        log_group_name(str, optional): Limits the returned queries to only those for the specified log group. Defaults to None.
        status(str, optional): Limits the returned queries to only those that have the specified status. Valid values are Cancelled, Complete, Failed, Running, and Scheduled. Defaults to None.
        max_results(int, optional): Limits the number of returned queries to the specified number. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. The token expires after 24 hours. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.query.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.query.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="describe_queries",
        op_kwargs={
            "logGroupName": log_group_name,
            "status": status,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def start(
    hub,
    ctx,
    start_time: int,
    end_time: int,
    query_string: str,
    log_group_name: str = None,
    log_group_names: List = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Schedules a query of a log group using CloudWatch Logs Insights. You specify the log group and time range to query and the query string to use. For more information, see CloudWatch Logs Insights Query Syntax. Queries time out after 15 minutes of execution. If your queries are timing out, reduce the time range being searched or partition your query into a number of queries.

    Args:
        log_group_name(str, optional): The log group on which to perform the query. A StartQuery operation must include a logGroupNames or a logGroupName parameter, but not both. Defaults to None.
        log_group_names(List, optional): The list of log groups to be queried. You can include up to 20 log groups. A StartQuery operation must include a logGroupNames or a logGroupName parameter, but not both. Defaults to None.
        start_time(int): The beginning of the time range to query. The range is inclusive, so the specified start time is included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.
        end_time(int): The end of the time range to query. The range is inclusive, so the specified end time is included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.
        query_string(str): The query string to use. For more information, see CloudWatch Logs Insights Query Syntax.
        limit(int, optional): The maximum number of log events to return in the query. If the query string uses the fields command, only the specified fields and their values are returned. The default is 1000. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.query.init.start(
                ctx, start_time=value, end_time=value, query_string=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.query.init.start start_time=value, end_time=value, query_string=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="start_query",
        op_kwargs={
            "logGroupName": log_group_name,
            "logGroupNames": log_group_names,
            "startTime": start_time,
            "endTime": end_time,
            "queryString": query_string,
            "limit": limit,
        },
    )


async def stop(hub, ctx, query_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a CloudWatch Logs Insights query that is in progress. If the query has already ended, the operation returns an error indicating that the specified query is not running.

    Args:
        query_id(str): The ID number of the query to stop. To find this ID number, use DescribeQueries.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.query.init.stop(ctx, query_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.query.init.stop query_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="stop_query",
        op_kwargs={"queryId": query_id},
    )
