"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, query_definition_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a saved CloudWatch Logs Insights query definition. A query definition contains details about a saved CloudWatch Logs Insights query. Each DeleteQueryDefinition operation can delete one query definition. You must have the logs:DeleteQueryDefinition permission to be able to perform this operation.

    Args:
        query_definition_id(str): The ID of the query definition that you want to delete. You can use DescribeQueryDefinitions to retrieve the IDs of your saved query definitions.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.query.definition.delete(ctx, query_definition_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.query.definition.delete query_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="delete_query_definition",
        op_kwargs={"queryDefinitionId": query_definition_id},
    )


async def describe_all(
    hub,
    ctx,
    query_definition_name_prefix: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation returns a paginated list of your saved CloudWatch Logs Insights query definitions. You can use the queryDefinitionNamePrefix parameter to limit the results to only the query definitions that have names that start with a certain string.

    Args:
        query_definition_name_prefix(str, optional): Use this parameter to filter your results to only the query definitions that have names that start with the prefix you specify. Defaults to None.
        max_results(int, optional): Limits the number of returned query definitions to the specified number. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. The token expires after 24 hours. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.query.definition.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.query.definition.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="describe_query_definitions",
        op_kwargs={
            "queryDefinitionNamePrefix": query_definition_name_prefix,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def put(
    hub,
    ctx,
    name: str,
    query_string: str,
    query_definition_id: str = None,
    log_group_names: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates a query definition for CloudWatch Logs Insights. For more information, see Analyzing Log Data with CloudWatch Logs Insights. To update a query definition, specify its queryDefinitionId in your request. The values of name, queryString, and logGroupNames are changed to the values that you specify in your update operation. No current values are retained from the current query definition. For example, if you update a current query definition that includes log groups, and you don't specify the logGroupNames parameter in your update operation, the query definition changes to contain no log groups. You must have the logs:PutQueryDefinition permission to be able to perform this operation.

    Args:
        name(str): A name for the query definition. If you are saving a lot of query definitions, we recommend that you name them so that you can easily find the ones you want by using the first part of the name as a filter in the queryDefinitionNamePrefix parameter of DescribeQueryDefinitions.
        query_definition_id(str, optional): If you are updating a query definition, use this parameter to specify the ID of the query definition that you want to update. You can use DescribeQueryDefinitions to retrieve the IDs of your saved query definitions. If you are creating a query definition, do not specify this parameter. CloudWatch generates a unique ID for the new query definition and include it in the response to this operation. Defaults to None.
        log_group_names(List, optional): Use this parameter to include specific log groups as part of your query definition. If you are updating a query definition and you omit this parameter, then the updated definition will contain no log groups. Defaults to None.
        query_string(str): The query string to use for this definition. For more information, see CloudWatch Logs Insights Query Syntax.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.query.definition.put(ctx, name=value, query_string=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.query.definition.put name=value, query_string=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="put_query_definition",
        op_kwargs={
            "name": name,
            "queryDefinitionId": query_definition_id,
            "logGroupNames": log_group_names,
            "queryString": query_string,
        },
    )
