"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "metric_filter"


async def delete(hub, ctx, log_group_name: str, filter_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified metric filter.

    Args:
        log_group_name(str): The name of the log group.
        filter_name(str): The name of the metric filter.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.metric_filter_.delete(
                ctx, log_group_name=value, filter_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.metric_filter.delete log_group_name=value, filter_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="delete_metric_filter",
        op_kwargs={"logGroupName": log_group_name, "filterName": filter_name},
    )


async def describe_all(
    hub,
    ctx,
    log_group_name: str = None,
    filter_name_prefix: str = None,
    next_token: str = None,
    limit: int = None,
    metric_name: str = None,
    metric_namespace: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the specified metric filters. You can list all of the metric filters or filter the results by log name, prefix, metric name, or metric namespace. The results are ASCII-sorted by filter name.

    Args:
        log_group_name(str, optional): The name of the log group. Defaults to None.
        filter_name_prefix(str, optional): The prefix to match. CloudWatch Logs uses the value you set here only if you also include the logGroupName parameter in your request. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        limit(int, optional): The maximum number of items returned. If you don't specify a value, the default is up to 50 items. Defaults to None.
        metric_name(str, optional): Filters results to include only those with the specified metric name. If you include this parameter in your request, you must also include the metricNamespace parameter. Defaults to None.
        metric_namespace(str, optional): Filters results to include only those in the specified namespace. If you include this parameter in your request, you must also include the metricName parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.metric_filter_.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.metric_filter.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="describe_metric_filters",
        op_kwargs={
            "logGroupName": log_group_name,
            "filterNamePrefix": filter_name_prefix,
            "nextToken": next_token,
            "limit": limit,
            "metricName": metric_name,
            "metricNamespace": metric_namespace,
        },
    )


async def put(
    hub,
    ctx,
    log_group_name: str,
    filter_name: str,
    filter_pattern: str,
    metric_transformations: List,
) -> None:
    r"""
    **Autogenerated function**

    Creates or updates a metric filter and associates it with the specified log group. Metric filters allow you to configure rules to extract metric data from log events ingested through PutLogEvents. The maximum number of metric filters that can be associated with a log group is 100. When you create a metric filter, you can also optionally assign a unit and dimensions to the metric that is created.  Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not specify high-cardinality fields such as IPAddress or requestID as dimensions. Each different value found for a dimension is treated as a separate metric and accrues charges as a separate custom metric.  To help prevent accidental high charges, Amazon disables a metric filter if it generates 1000 different name/value pairs for the dimensions that you have specified within a certain amount of time. You can also set up a billing alarm to alert you if your charges are higher than expected. For more information, see  Creating a Billing Alarm to Monitor Your Estimated AWS Charges.

    Args:
        log_group_name(str): The name of the log group.
        filter_name(str): A name for the metric filter.
        filter_pattern(str): A filter pattern for extracting metric data out of ingested log events.
        metric_transformations(List): A collection of information that defines how metric data gets emitted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.metric_filter_.put(
                ctx,
                log_group_name=value,
                filter_name=value,
                filter_pattern=value,
                metric_transformations=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.metric_filter.put log_group_name=value, filter_name=value, filter_pattern=value, metric_transformations=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="put_metric_filter",
        op_kwargs={
            "logGroupName": log_group_name,
            "filterName": filter_name,
            "filterPattern": filter_pattern,
            "metricTransformations": metric_transformations,
        },
    )


async def test(hub, ctx, filter_pattern: str, log_event_messages: List) -> Dict:
    r"""
    **Autogenerated function**

    Tests the filter pattern of a metric filter against a sample of log event messages. You can use this operation to validate the correctness of a metric filter pattern.

    Args:
        filter_pattern(str): A symbolic description of how CloudWatch Logs should interpret the data in each log event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You use the filter pattern to specify what to look for in the log event message.
        log_event_messages(List): The log event messages to test.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.metric_filter_.test(
                ctx, filter_pattern=value, log_event_messages=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.metric_filter.test filter_pattern=value, log_event_messages=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="test_metric_filter",
        op_kwargs={
            "filterPattern": filter_pattern,
            "logEventMessages": log_event_messages,
        },
    )
