"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, log_group_name: str, log_stream_name: str) -> None:
    r"""
    **Autogenerated function**

    Creates a log stream for the specified log group. A log stream is a sequence of log events that originate from a single source, such as an application instance or a resource that is being monitored. There is no limit on the number of log streams that you can create for a log group. There is a limit of 50 TPS on CreateLogStream operations, after which transactions are throttled. You must use the following guidelines when naming a log stream:   Log stream names must be unique within the log group.   Log stream names can be between 1 and 512 characters long.   The ':' (colon) and '*' (asterisk) characters are not allowed.

    Args:
        log_group_name(str): The name of the log group.
        log_stream_name(str): The name of the log stream.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.log.stream.create(
                ctx, log_group_name=value, log_stream_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.log.stream.create log_group_name=value, log_stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="create_log_stream",
        op_kwargs={"logGroupName": log_group_name, "logStreamName": log_stream_name},
    )


async def delete(hub, ctx, log_group_name: str, log_stream_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified log stream and permanently deletes all the archived log events associated with the log stream.

    Args:
        log_group_name(str): The name of the log group.
        log_stream_name(str): The name of the log stream.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.log.stream.delete(
                ctx, log_group_name=value, log_stream_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.log.stream.delete log_group_name=value, log_stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="delete_log_stream",
        op_kwargs={"logGroupName": log_group_name, "logStreamName": log_stream_name},
    )


async def describe_all(
    hub,
    ctx,
    log_group_name: str,
    log_stream_name_prefix: str = None,
    order_by: str = None,
    descending: bool = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the log streams for the specified log group. You can list all the log streams or filter the results by prefix. You can also control how the results are ordered. This operation has a limit of five transactions per second, after which transactions are throttled.

    Args:
        log_group_name(str): The name of the log group.
        log_stream_name_prefix(str, optional): The prefix to match. If orderBy is LastEventTime, you cannot specify this parameter. Defaults to None.
        order_by(str, optional): If the value is LogStreamName, the results are ordered by log stream name. If the value is LastEventTime, the results are ordered by the event time. The default value is LogStreamName. If you order the results by event time, you cannot specify the logStreamNamePrefix parameter.  lastEventTimestamp represents the time of the most recent log event in the log stream in CloudWatch Logs. This number is expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. lastEventTimestamp updates on an eventual consistency basis. It typically updates in less than an hour from ingestion, but in rare situations might take longer. Defaults to None.
        descending(bool, optional): If the value is true, results are returned in descending order. If the value is to false, results are returned in ascending order. The default value is false. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        limit(int, optional): The maximum number of items returned. If you don't specify a value, the default is up to 50 items. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.log.stream.describe_all(ctx, log_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.log.stream.describe_all log_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="describe_log_streams",
        op_kwargs={
            "logGroupName": log_group_name,
            "logStreamNamePrefix": log_stream_name_prefix,
            "orderBy": order_by,
            "descending": descending,
            "nextToken": next_token,
            "limit": limit,
        },
    )
