"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, log_record_pointer: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves all of the fields and values of a single log event. All fields are retrieved, even if the original query that produced the logRecordPointer retrieved only a subset of fields. Fields are returned as field name/field value pairs. The full unparsed log event is returned within @message.

    Args:
        log_record_pointer(str): The pointer corresponding to the log event record you want to retrieve. You get this from the response of a GetQueryResults operation. In that response, the value of the @ptr field for a log event is the value to use as logRecordPointer to retrieve that complete log event record.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.log.record.get(ctx, log_record_pointer=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.log.record.get log_record_pointer=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="get_log_record",
        op_kwargs={"logRecordPointer": log_record_pointer},
    )
