"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, log_group_name: str, kms_key_id: str = None, tags: Dict = None
) -> None:
    r"""
    **Autogenerated function**

    Creates a log group with the specified name. You can create up to 20,000 log groups per account. You must use the following guidelines when naming a log group:   Log group names must be unique within a region for an AWS account.   Log group names can be between 1 and 512 characters long.   Log group names consist of the following characters: a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), '/' (forward slash), '.' (period), and '#' (number sign)   When you create a log group, by default the log events in the log group never expire. To set a retention policy so that events expire and are deleted after a specified time, use PutRetentionPolicy. If you associate a AWS Key Management Service (AWS KMS) customer master key (CMK) with the log group, ingested data is encrypted using the CMK. This association is stored as long as the data encrypted with the CMK is still within Amazon CloudWatch Logs. This enables Amazon CloudWatch Logs to decrypt this data whenever it is requested. If you attempt to associate a CMK with the log group but the CMK does not exist or the CMK is disabled, you receive an InvalidParameterException error.    CloudWatch Logs supports only symmetric CMKs. Do not associate an asymmetric CMK with your log group. For more information, see Using Symmetric and Asymmetric Keys.

    Args:
        log_group_name(str): The name of the log group.
        kms_key_id(str, optional): The Amazon Resource Name (ARN) of the CMK to use when encrypting log data. For more information, see Amazon Resource Names - AWS Key Management Service (AWS KMS). Defaults to None.
        tags(Dict, optional): The key-value pairs to use for the tags. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.log.group.init.create(ctx, log_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.log.group.init.create log_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="create_log_group",
        op_kwargs={
            "logGroupName": log_group_name,
            "kmsKeyId": kms_key_id,
            "tags": tags,
        },
    )


async def delete(hub, ctx, log_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified log group and permanently deletes all the archived log events associated with the log group.

    Args:
        log_group_name(str): The name of the log group.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.log.group.init.delete(ctx, log_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.log.group.init.delete log_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="delete_log_group",
        op_kwargs={"logGroupName": log_group_name},
    )


async def describe_all(
    hub,
    ctx,
    log_group_name_prefix: str = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the specified log groups. You can list all your log groups or filter the results by prefix. The results are ASCII-sorted by log group name.

    Args:
        log_group_name_prefix(str, optional): The prefix to match. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        limit(int, optional): The maximum number of items returned. If you don't specify a value, the default is up to 50 items. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.log.group.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.log.group.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="describe_log_groups",
        op_kwargs={
            "logGroupNamePrefix": log_group_name_prefix,
            "nextToken": next_token,
            "limit": limit,
        },
    )


async def tag(hub, ctx, log_group_name: str, tags: Dict) -> None:
    r"""
    **Autogenerated function**

    Adds or updates the specified tags for the specified log group. To list the tags for a log group, use ListTagsLogGroup. To remove tags, use UntagLogGroup. For more information about tags, see Tag Log Groups in Amazon CloudWatch Logs in the Amazon CloudWatch Logs User Guide.

    Args:
        log_group_name(str): The name of the log group.
        tags(Dict): The key-value pairs to use for the tags.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.log.group.init.tag(ctx, log_group_name=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.log.group.init.tag log_group_name=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="tag_log_group",
        op_kwargs={"logGroupName": log_group_name, "tags": tags},
    )


async def untag(hub, ctx, log_group_name: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Removes the specified tags from the specified log group. To list the tags for a log group, use ListTagsLogGroup. To add tags, use TagLogGroup.

    Args:
        log_group_name(str): The name of the log group.
        tags(List): The tag keys. The corresponding tags are removed from the log group.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.log.group.init.untag(ctx, log_group_name=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.log.group.init.untag log_group_name=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="untag_log_group",
        op_kwargs={"logGroupName": log_group_name, "tags": tags},
    )
