"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, log_group_name: str, time: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the fields that are included in log events in the specified log group, along with the percentage of log events that contain each field. The search is limited to a time period that you specify. In the results, fields that start with @ are fields generated by CloudWatch Logs. For example, @timestamp is the timestamp of each log event. For more information about the fields that are generated by CloudWatch logs, see Supported Logs and Discovered Fields. The response results are sorted by the frequency percentage, starting with the highest percentage.

    Args:
        log_group_name(str): The name of the log group to search.
        time(int, optional): The time to set as the center of the query. If you specify time, the 15 minutes before this time are queries. If you omit time the 8 minutes before and 8 minutes after this time are searched. The time value is specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.log.group.field.get_all(ctx, log_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.log.group.field.get_all log_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="get_log_group_fields",
        op_kwargs={"logGroupName": log_group_name, "time": time},
    )
