"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"filter_": "filter"}


async def filter_(
    hub,
    ctx,
    log_group_name: str,
    log_stream_names: List = None,
    log_stream_name_prefix: str = None,
    start_time: int = None,
    end_time: int = None,
    filter_pattern: str = None,
    next_token: str = None,
    limit: int = None,
    interleaved: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists log events from the specified log group. You can list all the log events or filter the results using a filter pattern, a time range, and the name of the log stream. By default, this operation returns as many log events as can fit in 1 MB (up to 10,000 log events) or all the events found within the time range that you specify. If the results include a token, then there are more log events available, and you can get additional results by specifying the token in a subsequent call. This operation can return empty results while there are more log events available through the token. The returned log events are sorted by event timestamp, the timestamp when the event was ingested by CloudWatch Logs, and the ID of the PutLogEvents request.

    Args:
        log_group_name(str): The name of the log group to search.
        log_stream_names(List, optional): Filters the results to only logs from the log streams in this list. If you specify a value for both logStreamNamePrefix and logStreamNames, the action returns an InvalidParameterException error. Defaults to None.
        log_stream_name_prefix(str, optional): Filters the results to include only events from log streams that have names starting with this prefix. If you specify a value for both logStreamNamePrefix and logStreamNames, but the value for logStreamNamePrefix does not match any log stream names specified in logStreamNames, the action returns an InvalidParameterException error. Defaults to None.
        start_time(int, optional): The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp before this time are not returned. Defaults to None.
        end_time(int, optional): The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp later than this time are not returned. Defaults to None.
        filter_pattern(str, optional): The filter pattern to use. For more information, see Filter and Pattern Syntax. If not provided, all the events are matched. Defaults to None.
        next_token(str, optional): The token for the next set of events to return. (You received this token from a previous call.). Defaults to None.
        limit(int, optional): The maximum number of events to return. The default is 10,000 events. Defaults to None.
        interleaved(bool, optional): If the value is true, the operation makes a best effort to provide responses that contain events from multiple log streams within the log group, interleaved in a single response. If the value is false, all the matched log events in the first log stream are searched first, then those in the next log stream, and so on. The default is false.  Important: Starting on June 17, 2019, this parameter is ignored and the value is assumed to be true. The response from this operation always interleaves events from multiple log streams within a log group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.log.event.filter(ctx, log_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.log.event.filter log_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="filter_log_events",
        op_kwargs={
            "logGroupName": log_group_name,
            "logStreamNames": log_stream_names,
            "logStreamNamePrefix": log_stream_name_prefix,
            "startTime": start_time,
            "endTime": end_time,
            "filterPattern": filter_pattern,
            "nextToken": next_token,
            "limit": limit,
            "interleaved": interleaved,
        },
    )


async def get_all(
    hub,
    ctx,
    log_group_name: str,
    log_stream_name: str,
    start_time: int = None,
    end_time: int = None,
    next_token: str = None,
    limit: int = None,
    start_from_head: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists log events from the specified log stream. You can list all of the log events or filter using a time range. By default, this operation returns as many log events as can fit in a response size of 1MB (up to 10,000 log events). You can get additional log events by specifying one of the tokens in a subsequent call. This operation can return empty results while there are more log events available through the token.

    Args:
        log_group_name(str): The name of the log group.
        log_stream_name(str): The name of the log stream.
        start_time(int, optional): The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to this time or later than this time are included. Events with a timestamp earlier than this time are not included. Defaults to None.
        end_time(int, optional): The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to or later than this time are not included. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.) Using this token works only when you specify true for startFromHead. Defaults to None.
        limit(int, optional): The maximum number of log events returned. If you don't specify a value, the maximum is as many log events as can fit in a response size of 1 MB, up to 10,000 log events. Defaults to None.
        start_from_head(bool, optional): If the value is true, the earliest log events are returned first. If the value is false, the latest log events are returned first. The default value is false. If you are using nextToken in this operation, you must specify true for startFromHead. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.log.event.get_all(
                ctx, log_group_name=value, log_stream_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.log.event.get_all log_group_name=value, log_stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="get_log_events",
        op_kwargs={
            "logGroupName": log_group_name,
            "logStreamName": log_stream_name,
            "startTime": start_time,
            "endTime": end_time,
            "nextToken": next_token,
            "limit": limit,
            "startFromHead": start_from_head,
        },
    )


async def put_multiple(
    hub,
    ctx,
    log_group_name: str,
    log_stream_name: str,
    log_events: List,
    sequence_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Uploads a batch of log events to the specified log stream. You must include the sequence token obtained from the response of the previous call. An upload in a newly created log stream does not require a sequence token. You can also get the sequence token in the expectedSequenceToken field from InvalidSequenceTokenException. If you call PutLogEvents twice within a narrow time period using the same value for sequenceToken, both calls might be successful or one might be rejected. The batch of events must satisfy the following constraints:   The maximum batch size is 1,048,576 bytes. This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for each log event.   None of the log events in the batch can be more than 2 hours in the future.   None of the log events in the batch can be older than 14 days or older than the retention period of the log group.   The log events in the batch must be in chronological order by their timestamp. The timestamp is the time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. (In AWS Tools for PowerShell and the AWS SDK for .NET, the timestamp is specified in .NET format: yyyy-mm-ddThh:mm:ss. For example, 2017-09-15T13:45:30.)    A batch of log events in a single request cannot span more than 24 hours. Otherwise, the operation fails.   The maximum number of log events in a batch is 10,000.   There is a quota of 5 requests per second per log stream. Additional requests are throttled. This quota can't be changed.   If a call to PutLogEvents returns "UnrecognizedClientException" the most likely cause is an invalid AWS access key ID or secret key.

    Args:
        log_group_name(str): The name of the log group.
        log_stream_name(str): The name of the log stream.
        log_events(List): The log events.
        sequence_token(str, optional): The sequence token obtained from the response of the previous PutLogEvents call. An upload in a newly created log stream does not require a sequence token. You can also get the sequence token using DescribeLogStreams. If you call PutLogEvents twice within a narrow time period using the same value for sequenceToken, both calls might be successful or one might be rejected. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.log.event.put_multiple(
                ctx, log_group_name=value, log_stream_name=value, log_events=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.log.event.put_multiple log_group_name=value, log_stream_name=value, log_events=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="put_log_events",
        op_kwargs={
            "logGroupName": log_group_name,
            "logStreamName": log_stream_name,
            "logEvents": log_events,
            "sequenceToken": sequence_token,
        },
    )
