"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def associate(hub, ctx, log_group_name: str, kms_key_id: str) -> None:
    r"""
    **Autogenerated function**

    Associates the specified AWS Key Management Service (AWS KMS) customer master key (CMK) with the specified log group. Associating an AWS KMS CMK with a log group overrides any existing associations between the log group and a CMK. After a CMK is associated with a log group, all newly ingested data for the log group is encrypted using the CMK. This association is stored as long as the data encrypted with the CMK is still within Amazon CloudWatch Logs. This enables Amazon CloudWatch Logs to decrypt this data whenever it is requested.  CloudWatch Logs supports only symmetric CMKs. Do not use an associate an asymmetric CMK with your log group. For more information, see Using Symmetric and Asymmetric Keys.  It can take up to 5 minutes for this operation to take effect. If you attempt to associate a CMK with a log group but the CMK does not exist or the CMK is disabled, you receive an InvalidParameterException error.

    Args:
        log_group_name(str): The name of the log group.
        kms_key_id(str): The Amazon Resource Name (ARN) of the CMK to use when encrypting log data. This must be a symmetric CMK. For more information, see Amazon Resource Names - AWS Key Management Service (AWS KMS) and Using Symmetric and Asymmetric Keys.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.kms_key.associate(
                ctx, log_group_name=value, kms_key_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.kms_key.associate log_group_name=value, kms_key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="associate_kms_key",
        op_kwargs={"logGroupName": log_group_name, "kmsKeyId": kms_key_id},
    )


async def disassociate(hub, ctx, log_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Disassociates the associated AWS Key Management Service (AWS KMS) customer master key (CMK) from the specified log group. After the AWS KMS CMK is disassociated from the log group, AWS CloudWatch Logs stops encrypting newly ingested data for the log group. All previously ingested data remains encrypted, and AWS CloudWatch Logs requires permissions for the CMK whenever the encrypted data is requested. Note that it can take up to 5 minutes for this operation to take effect.

    Args:
        log_group_name(str): The name of the log group.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.kms_key.disassociate(ctx, log_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.kms_key.disassociate log_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="disassociate_kms_key",
        op_kwargs={"logGroupName": log_group_name},
    )
