"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, task_id: str) -> None:
    r"""
    **Autogenerated function**

    Cancels the specified export task. The task must be in the PENDING or RUNNING state.

    Args:
        task_id(str): The ID of the export task.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.export_task.cancel(ctx, task_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.export_task.cancel task_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="cancel_export_task",
        op_kwargs={"taskId": task_id},
    )


async def create(
    hub,
    ctx,
    log_group_name: str,
    from_: int,
    to: int,
    destination: str,
    task_name: str = None,
    log_stream_name_prefix: str = None,
    destination_prefix: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an export task, which allows you to efficiently export data from a log group to an Amazon S3 bucket. When you perform a CreateExportTask operation, you must use credentials that have permission to write to the S3 bucket that you specify as the destination. This is an asynchronous call. If all the required information is provided, this operation initiates an export task and responds with the ID of the task. After the task has started, you can use DescribeExportTasks to get the status of the export task. Each account can only have one active (RUNNING or PENDING) export task at a time. To cancel an export task, use CancelExportTask. You can export logs from multiple log groups or multiple time ranges to the same S3 bucket. To separate out log data for each export task, you can specify a prefix to be used as the Amazon S3 key prefix for all exported objects. Exporting to S3 buckets that are encrypted with AES-256 is supported. Exporting to S3 buckets encrypted with SSE-KMS is not supported.

    Args:
        task_name(str, optional): The name of the export task. Defaults to None.
        log_group_name(str): The name of the log group.
        log_stream_name_prefix(str, optional): Export only log streams that match the provided prefix. If you don't specify a value, no prefix filter is applied. Defaults to None.
        from_(int): The start time of the range for the request, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp earlier than this time are not exported.
        to(int): The end time of the range for the request, expreswatchlogsdocused as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp later than this time are not exported.
        destination(str): The name of S3 bucket for the exported log data. The bucket must be in the same AWS region.
        destination_prefix(str, optional): The prefix used as the start of the key for every object exported. If you don't specify a value, the default is exportedlogs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.export_task.create(
                ctx, log_group_name=value, from_=value, to=value, destination=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.export_task.create log_group_name=value, from_=value, to=value, destination=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="create_export_task",
        op_kwargs={
            "taskName": task_name,
            "logGroupName": log_group_name,
            "logStreamNamePrefix": log_stream_name_prefix,
            "from": from_,
            "to": to,
            "destination": destination,
            "destinationPrefix": destination_prefix,
        },
    )


async def describe_all(
    hub,
    ctx,
    task_id: str = None,
    status_code: str = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the specified export tasks. You can list all your export tasks or filter the results based on task ID or task status.

    Args:
        task_id(str, optional): The ID of the export task. Specifying a task ID filters the results to zero or one export tasks. Defaults to None.
        status_code(str, optional): The status code of the export task. Specifying a status code filters the results to zero or more export tasks. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        limit(int, optional): The maximum number of items returned. If you don't specify a value, the default is up to 50 items. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.export_task.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.export_task.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="describe_export_tasks",
        op_kwargs={
            "taskId": task_id,
            "statusCode": status_code,
            "nextToken": next_token,
            "limit": limit,
        },
    )
