"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def put(hub, ctx, destination_name: str, access_policy: str) -> None:
    r"""
    **Autogenerated function**

    Creates or updates an access policy associated with an existing destination. An access policy is an IAM policy document that is used to authorize claims to register a subscription filter against a given destination. If multiple AWS accounts are sending logs to this destination, each sender account must be listed separately in the policy. The policy does not support specifying * as the Principal or the use of the aws:PrincipalOrgId global key.

    Args:
        destination_name(str): A name for an existing destination.
        access_policy(str): An IAM policy document that authorizes cross-account users to deliver their log events to the associated destination. This can be up to 5120 bytes.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.destination.policy.put(
                ctx, destination_name=value, access_policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.destination.policy.put destination_name=value, access_policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="put_destination_policy",
        op_kwargs={"destinationName": destination_name, "accessPolicy": access_policy},
    )
