"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, destination_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified destination, and eventually disables all the subscription filters that publish to it. This operation does not delete the physical resource encapsulated by the destination.

    Args:
        destination_name(str): The name of the destination.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.destination.init.delete(ctx, destination_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.destination.init.delete destination_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="delete_destination",
        op_kwargs={"destinationName": destination_name},
    )


async def describe_all(
    hub,
    ctx,
    destination_name_prefix: str = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all your destinations. The results are ASCII-sorted by destination name.

    Args:
        destination_name_prefix(str, optional): The prefix to match. If you don't specify a value, no prefix filter is applied. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        limit(int, optional): The maximum number of items returned. If you don't specify a value, the default is up to 50 items. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.destination.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.destination.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="describe_destinations",
        op_kwargs={
            "DestinationNamePrefix": destination_name_prefix,
            "nextToken": next_token,
            "limit": limit,
        },
    )


async def put(hub, ctx, destination_name: str, target_arn: str, role_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates a destination. This operation is used only to create destinations for cross-account subscriptions. A destination encapsulates a physical resource (such as an Amazon Kinesis stream) and enables you to subscribe to a real-time stream of log events for a different account, ingested using PutLogEvents. Through an access policy, a destination controls what is written to it. By default, PutDestination does not set any access policy with the destination, which means a cross-account user cannot call PutSubscriptionFilter against this destination. To enable this, the destination owner must call PutDestinationPolicy after PutDestination. To perform a PutDestination operation, you must also have the iam:PassRole permission.

    Args:
        destination_name(str): A name for the destination.
        target_arn(str): The ARN of an Amazon Kinesis stream to which to deliver matching log events.
        role_arn(str): The ARN of an IAM role that grants CloudWatch Logs permissions to call the Amazon Kinesis PutRecord operation on the destination stream.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.logs.destination.init.put(
                ctx, destination_name=value, target_arn=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.logs.destination.init.put destination_name=value, target_arn=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="logs",
        operation="put_destination",
        op_kwargs={
            "destinationName": destination_name,
            "targetArn": target_arn,
            "roleArn": role_arn,
        },
    )
