"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, tracker_name: str, updates: List) -> Dict:
    r"""
    **Autogenerated function**

    Uploads position update data for one or more devices to a tracker resource. Amazon Location uses the data when reporting the last known device position and position history.  Only one position update is stored per sample time. Location data is sampled at a fixed rate of one position per 30-second interval and retained for 30 days before it's deleted.

    Args:
        tracker_name(str): The name of the tracker resource to update.
        updates(List): Contains the position update details for each device.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.update_device_position.batch(
                ctx, tracker_name=value, updates=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.update_device_position.batch tracker_name=value, updates=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="batch_update_device_position",
        op_kwargs={"TrackerName": tracker_name, "Updates": updates},
    )
