"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    pricing_plan: str,
    tracker_name: str,
    description: str = None,
    kms_key_id: str = None,
    pricing_plan_data_source: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a tracker resource in your AWS account, which lets you retrieve current and historical location of devices.

    Args:
        description(str, optional): An optional description for the tracker resource. Defaults to None.
        kms_key_id(str, optional): A key identifier for an AWS KMS customer managed key. Enter a key ID, key ARN, alias name, or alias ARN. Defaults to None.
        pricing_plan(str): Specifies the pricing plan for the tracker resource. For additional details and restrictions on each pricing plan option, see the Amazon Location Service pricing page.
        pricing_plan_data_source(str, optional): Specifies the data provider for the tracker resource.   Required value for the following pricing plans: MobileAssetTracking | MobileAssetManagement    For more information about Data Providers, and Pricing plans, see the Amazon Location Service product page.  Amazon Location Service only uses PricingPlanDataSource to calculate billing for your tracker resource. Your data will not be shared with the data provider, and will remain in your AWS account or Region unless you move it.  Valid Values: Esri | Here . Defaults to None.
        tags(Dict, optional): Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them. Format: "key" : "value"  Restrictions:   Maximum 50 tags per resource   Each resource tag must be unique with a maximum of one value.   Maximum key length: 128 Unicode characters in UTF-8   Maximum value length: 256 Unicode characters in UTF-8   Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.   . Defaults to None.
        tracker_name(str): The name for the tracker resource. Requirements:   Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).   Must be a unique tracker resource name.   No spaces allowed. For example, ExampleTracker.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.tracker.init.create(
                ctx, pricing_plan=value, tracker_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.tracker.init.create pricing_plan=value, tracker_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="create_tracker",
        op_kwargs={
            "Description": description,
            "KmsKeyId": kms_key_id,
            "PricingPlan": pricing_plan,
            "PricingPlanDataSource": pricing_plan_data_source,
            "Tags": tags,
            "TrackerName": tracker_name,
        },
    )


async def delete(hub, ctx, tracker_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a tracker resource from your AWS account.  This operation deletes the resource permanently. If the tracker resource is in use, you may encounter an error. Make sure that the target resource isn't a dependency for your applications.

    Args:
        tracker_name(str): The name of the tracker resource to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.tracker.init.delete(ctx, tracker_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.tracker.init.delete tracker_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="delete_tracker",
        op_kwargs={"TrackerName": tracker_name},
    )


async def describe(hub, ctx, tracker_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the tracker resource details.

    Args:
        tracker_name(str): The name of the tracker resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.tracker.init.describe(ctx, tracker_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.tracker.init.describe tracker_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="describe_tracker",
        op_kwargs={"TrackerName": tracker_name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists tracker resources in your AWS account.

    Args:
        max_results(int, optional): An optional limit for the number of resources returned in a single call.  Default value: 100 . Defaults to None.
        next_token(str, optional): The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.  Default value: null . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.tracker.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.tracker.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="list_trackers",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    tracker_name: str,
    description: str = None,
    pricing_plan: str = None,
    pricing_plan_data_source: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified properties of a given tracker resource.

    Args:
        description(str, optional): Updates the description for the tracker resource. Defaults to None.
        pricing_plan(str, optional): Updates the pricing plan for the tracker resource. For more information about each pricing plan option restrictions, see Amazon Location Service pricing. Defaults to None.
        pricing_plan_data_source(str, optional): Updates the data provider for the tracker resource.  A required value for the following pricing plans: MobileAssetTracking| MobileAssetManagement  For more information about data providers and pricing plans, see the Amazon Location Service product page  This can only be updated when updating the PricingPlan in the same request. Amazon Location Service uses PricingPlanDataSource to calculate billing for your tracker resource. Your data won't be shared with the data provider, and will remain in your AWS account and Region unless you move it. . Defaults to None.
        tracker_name(str): The name of the tracker resource to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.tracker.init.update(ctx, tracker_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.tracker.init.update tracker_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="update_tracker",
        op_kwargs={
            "Description": description,
            "PricingPlan": pricing_plan,
            "PricingPlanDataSource": pricing_plan_data_source,
            "TrackerName": tracker_name,
        },
    )
