"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, consumer_arn: str, tracker_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates an association between a geofence collection and a tracker resource. This allows the tracker resource to communicate location data to the linked geofence collection.  You can associate up to five geofence collections to each tracker resource.  Currently not supported — Cross-account configurations, such as creating associations between a tracker resource in one account and a geofence collection in another account.

    Args:
        consumer_arn(str): The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.   Format example: arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer   .
        tracker_name(str): The name of the tracker resource to be associated with a geofence collection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.tracker.consumer.associate(
                ctx, consumer_arn=value, tracker_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.tracker.consumer.associate consumer_arn=value, tracker_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="associate_tracker_consumer",
        op_kwargs={"ConsumerArn": consumer_arn, "TrackerName": tracker_name},
    )


async def disassociate(hub, ctx, consumer_arn: str, tracker_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes the association between a tracker resource and a geofence collection.  Once you unlink a tracker resource from a geofence collection, the tracker positions will no longer be automatically evaluated against geofences.

    Args:
        consumer_arn(str): The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker resource. Used when you need to specify a resource across all AWS.    Format example: arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer   .
        tracker_name(str): The name of the tracker resource to be dissociated from the consumer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.tracker.consumer.disassociate(
                ctx, consumer_arn=value, tracker_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.tracker.consumer.disassociate consumer_arn=value, tracker_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="disassociate_tracker_consumer",
        op_kwargs={"ConsumerArn": consumer_arn, "TrackerName": tracker_name},
    )


async def list_all(
    hub, ctx, tracker_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists geofence collections currently associated to the given tracker resource.

    Args:
        max_results(int, optional): An optional limit for the number of resources returned in a single call.  Default value: 100 . Defaults to None.
        next_token(str, optional): The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.  Default value: null . Defaults to None.
        tracker_name(str): The tracker resource whose associated geofence collections you want to list.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.tracker.consumer.list_all(ctx, tracker_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.tracker.consumer.list_all tracker_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="list_tracker_consumers",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "TrackerName": tracker_name,
        },
    )
