"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    calculator_name: str,
    data_source: str,
    pricing_plan: str,
    description: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a route calculator resource in your AWS account. You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A route calculator sources traffic and road network data from your chosen data provider.

    Args:
        calculator_name(str): The name of the route calculator resource.  Requirements:   Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).   Must be a unique Route calculator resource name.   No spaces allowed. For example, ExampleRouteCalculator.  .
        data_source(str): Specifies the data provider of traffic and road network data.  This field is case-sensitive. Enter the valid values as shown. For example, entering HERE returns an error.  Valid values include:    Esri – For additional information about Esri's coverage in your region of interest, see Esri details on street networks and traffic coverage.    Here – For additional information about HERE Technologies's coverage in your region of interest, see HERE car routing coverage and HERE truck routing coverage.   For additional information , see Data providers on the Amazon Location Service Developer Guide.
        description(str, optional): The optional description for the route calculator resource. Defaults to None.
        pricing_plan(str): Specifies the pricing plan for your route calculator resource. For additional details and restrictions on each pricing plan option, see Amazon Location Service pricing.
        tags(Dict, optional): Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.   For example: { "tag1" : "value1", "tag2" : "value2"}   Format: "key" : "value"  Restrictions:   Maximum 50 tags per resource   Each resource tag must be unique with a maximum of one value.   Maximum key length: 128 Unicode characters in UTF-8   Maximum value length: 256 Unicode characters in UTF-8   Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.route.calculator.create(
                ctx, calculator_name=value, data_source=value, pricing_plan=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.route.calculator.create calculator_name=value, data_source=value, pricing_plan=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="create_route_calculator",
        op_kwargs={
            "CalculatorName": calculator_name,
            "DataSource": data_source,
            "Description": description,
            "PricingPlan": pricing_plan,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, calculator_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a route calculator resource from your AWS account.  This operation deletes the resource permanently.

    Args:
        calculator_name(str): The name of the route calculator resource to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.route.calculator.delete(ctx, calculator_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.route.calculator.delete calculator_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="delete_route_calculator",
        op_kwargs={"CalculatorName": calculator_name},
    )


async def describe(hub, ctx, calculator_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the route calculator resource details.

    Args:
        calculator_name(str): The name of the route calculator resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.route.calculator.describe(ctx, calculator_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.route.calculator.describe calculator_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="describe_route_calculator",
        op_kwargs={"CalculatorName": calculator_name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists route calculator resources in your AWS account.

    Args:
        max_results(int, optional): An optional maximum number of results returned in a single call. Default Value: 100 . Defaults to None.
        next_token(str, optional): The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. Default Value: null . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.route.calculator.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.route.calculator.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="list_route_calculators",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub, ctx, calculator_name: str, description: str = None, pricing_plan: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified properties for a given route calculator resource.

    Args:
        calculator_name(str): The name of the route calculator resource to update.
        description(str, optional): Updates the description for the route calculator resource. Defaults to None.
        pricing_plan(str, optional): Updates the pricing plan for the route calculator resource. For more information about each pricing plan option restrictions, see Amazon Location Service pricing. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.route.calculator.update(ctx, calculator_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.route.calculator.update calculator_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="update_route_calculator",
        op_kwargs={
            "CalculatorName": calculator_name,
            "Description": description,
            "PricingPlan": pricing_plan,
        },
    )
