"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, collection_name: str, entries: List) -> Dict:
    r"""
    **Autogenerated function**

    A batch request for storing geofence geometries into a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.

    Args:
        collection_name(str): The geofence collection storing the geofences.
        entries(List): The batch of geofences to be stored in a geofence collection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.put_geofence.batch(
                ctx, collection_name=value, entries=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.put_geofence.batch collection_name=value, entries=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="batch_put_geofence",
        op_kwargs={"CollectionName": collection_name, "Entries": entries},
    )
