"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    data_source: str,
    index_name: str,
    pricing_plan: str,
    data_source_configuration: Dict = None,
    description: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a place index resource in your AWS account, which supports functions with geospatial data sourced from your chosen data provider.

    Args:
        data_source(str): Specifies the data provider of geospatial data.  This field is case-sensitive. Enter the valid values as shown. For example, entering HERE returns an error.  Valid values include:    Esri – For additional information about Esri's coverage in your region of interest, see Esri details on geocoding coverage.    Here – For additional information about HERE Technologies's coverage in your region of interest, see HERE details on goecoding coverage.  Place index resources using HERE Technologies as a data provider can't store results for locations in Japan. For more information, see the AWS Service Terms for Amazon Location Service.    For additional information , see Data providers on the Amazon Location Service Developer Guide.
        data_source_configuration(Dict, optional): Specifies the data storage option requesting Places. Defaults to None.
        description(str, optional): The optional description for the place index resource. Defaults to None.
        index_name(str): The name of the place index resource.  Requirements:   Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).   Must be a unique place index resource name.   No spaces allowed. For example, ExamplePlaceIndex.  .
        pricing_plan(str): Specifies the pricing plan for your place index resource. For additional details and restrictions on each pricing plan option, see the Amazon Location Service pricing page.
        tags(Dict, optional): Applies one or more tags to the place index resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them. Format: "key" : "value"  Restrictions:   Maximum 50 tags per resource   Each resource tag must be unique with a maximum of one value.   Maximum key length: 128 Unicode characters in UTF-8   Maximum value length: 256 Unicode characters in UTF-8   Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.place_index.init.create(
                ctx, data_source=value, index_name=value, pricing_plan=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.place_index.init.create data_source=value, index_name=value, pricing_plan=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="create_place_index",
        op_kwargs={
            "DataSource": data_source,
            "DataSourceConfiguration": data_source_configuration,
            "Description": description,
            "IndexName": index_name,
            "PricingPlan": pricing_plan,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, index_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a place index resource from your AWS account.  This operation deletes the resource permanently.

    Args:
        index_name(str): The name of the place index resource to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.place_index.init.delete(ctx, index_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.place_index.init.delete index_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="delete_place_index",
        op_kwargs={"IndexName": index_name},
    )


async def describe(hub, ctx, index_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the place index resource details.

    Args:
        index_name(str): The name of the place index resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.place_index.init.describe(ctx, index_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.place_index.init.describe index_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="describe_place_index",
        op_kwargs={"IndexName": index_name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists place index resources in your AWS account.

    Args:
        max_results(int, optional): An optional limit for the maximum number of results returned in a single call. Default value: 100 . Defaults to None.
        next_token(str, optional): The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. Default value: null . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.place_index.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.place_index.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="list_place_indexes",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    index_name: str,
    data_source_configuration: Dict = None,
    description: str = None,
    pricing_plan: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified properties of a given place index resource.

    Args:
        data_source_configuration(Dict, optional): Updates the data storage option for the place index resource. Defaults to None.
        description(str, optional): Updates the description for the place index resource. Defaults to None.
        index_name(str): The name of the place index resource to update.
        pricing_plan(str, optional): Updates the pricing plan for the place index resource. For more information about each pricing plan option restrictions, see Amazon Location Service pricing. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.place_index.init.update(ctx, index_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.place_index.init.update index_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="update_place_index",
        op_kwargs={
            "DataSourceConfiguration": data_source_configuration,
            "Description": description,
            "IndexName": index_name,
            "PricingPlan": pricing_plan,
        },
    )
