"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists map resources in your AWS account.

    Args:
        max_results(int, optional): An optional limit for the number of resources returned in a single call.  Default value: 100 . Defaults to None.
        next_token(str, optional): The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. Default value: null . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.maps.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.maps.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="list_maps",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
