"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, map_name: str, x: str, y: str, z: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a vector data tile from the map resource. Map tiles are used by clients to render a map. they're addressed using a grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level.  The origin (0, 0) is the top left of the map. Increasing the zoom level by 1 doubles both the X and Y dimensions, so a tile containing data for the entire world at (0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1, 1/1/0, 1/1/1).

    Args:
        map_name(str): The map resource to retrieve the map tiles from.
        x(str): The X axis value for the map tile.
        y(str): The Y axis value for the map tile. .
        z(str): The zoom value for the map tile.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.map_.tile.get(
                ctx, map_name=value, x=value, y=value, z=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.map_.tile.get map_name=value, x=value, y=value, z=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="get_map_tile",
        op_kwargs={"MapName": map_name, "X": x, "Y": y, "Z": z},
    )
