"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, map_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the map style descriptor from a map resource.  The style descriptor contains speciﬁcations on how features render on a map. For example, what data to display, what order to display the data in, and the style for the data. Style descriptors follow the Mapbox Style Specification.

    Args:
        map_name(str): The map resource to retrieve the style descriptor from.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.map_.style_descriptor.get(ctx, map_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.map_.style_descriptor.get map_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="get_map_style_descriptor",
        op_kwargs={"MapName": map_name},
    )
