"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, file_name: str, map_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG image paired with a JSON document describing the offsets of individual icons that will be displayed on a rendered map.

    Args:
        file_name(str): The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:    sprites.png     sprites@2x.png for high pixel density displays   For the JSON document contain image offsets. Use the following ﬁle names:    sprites.json     sprites@2x.json for high pixel density displays  .
        map_name(str): The map resource associated with the sprite ﬁle.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.map_.sprite.get_all(
                ctx, file_name=value, map_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.map_.sprite.get_all file_name=value, map_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="get_map_sprites",
        op_kwargs={"FileName": file_name, "MapName": map_name},
    )
