"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    configuration: Dict,
    map_name: str,
    pricing_plan: str,
    description: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a map resource in your AWS account, which provides map tiles of different styles sourced from global location data providers.

    Args:
        configuration(Dict): Specifies the map style selected from an available data provider.
        description(str, optional): An optional description for the map resource. Defaults to None.
        map_name(str): The name for the map resource. Requirements:   Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).    Must be a unique map resource name.    No spaces allowed. For example, ExampleMap.  .
        pricing_plan(str): Specifies the pricing plan for your map resource. For additional details and restrictions on each pricing plan option, see the Amazon Location Service pricing page.
        tags(Dict, optional): Applies one or more tags to the map resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them. Format: "key" : "value"  Restrictions:   Maximum 50 tags per resource   Each resource tag must be unique with a maximum of one value.   Maximum key length: 128 Unicode characters in UTF-8   Maximum value length: 256 Unicode characters in UTF-8   Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.map_.init.create(
                ctx, configuration=value, map_name=value, pricing_plan=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.map_.init.create configuration=value, map_name=value, pricing_plan=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="create_map",
        op_kwargs={
            "Configuration": configuration,
            "Description": description,
            "MapName": map_name,
            "PricingPlan": pricing_plan,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, map_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a map resource from your AWS account.  This operation deletes the resource permanently. If the map is being used in an application, the map may not render.

    Args:
        map_name(str): The name of the map resource to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.map_.init.delete(ctx, map_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.map_.init.delete map_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="delete_map",
        op_kwargs={"MapName": map_name},
    )


async def describe(hub, ctx, map_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the map resource details.

    Args:
        map_name(str): The name of the map resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.map_.init.describe(ctx, map_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.map_.init.describe map_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="describe_map",
        op_kwargs={"MapName": map_name},
    )


async def update(
    hub, ctx, map_name: str, description: str = None, pricing_plan: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified properties of a given map resource.

    Args:
        description(str, optional): Updates the description for the map resource. Defaults to None.
        map_name(str): The name of the map resource to update.
        pricing_plan(str, optional): Updates the pricing plan for the map resource. For more information about each pricing plan option restrictions, see Amazon Location Service pricing. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.map_.init.update(ctx, map_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.map_.init.update map_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="update_map",
        op_kwargs={
            "Description": description,
            "MapName": map_name,
            "PricingPlan": pricing_plan,
        },
    )
