"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, font_stack: str, font_unicode_range: str, map_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves glyphs used to display labels on a map.

    Args:
        font_stack(str): A comma-separated list of fonts to load glyphs from in order of preference. For example, Noto Sans Regular, Arial Unicode. Valid fonts for Esri styles:    VectorEsriDarkGrayCanvas – Ubuntu Medium Italic | Ubuntu Medium | Ubuntu Italic | Ubuntu Regular | Ubuntu Bold    VectorEsriLightGrayCanvas – Ubuntu Italic | Ubuntu Regular | Ubuntu Light | Ubuntu Bold    VectorEsriTopographic – Noto Sans Italic | Noto Sans Regular | Noto Sans Bold | Noto Serif Regular | Roboto Condensed Light Italic    VectorEsriStreets – Arial Regular | Arial Italic | Arial Bold    VectorEsriNavigation – Arial Regular | Arial Italic | Arial Bold    Valid fonts for HERE Technologies styles:     VectorHereBerlin – Fira GO Regular | Fira GO Bold   .
        font_unicode_range(str): A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For example, 0–255 includes all characters from range U+0000 to 00FF. Must be aligned to multiples of 256.
        map_name(str): The map resource associated with the glyph ﬁle.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.map_.glyph.get_all(
                ctx, font_stack=value, font_unicode_range=value, map_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.map_.glyph.get_all font_stack=value, font_unicode_range=value, map_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="get_map_glyphs",
        op_kwargs={
            "FontStack": font_stack,
            "FontUnicodeRange": font_unicode_range,
            "MapName": map_name,
        },
    )
